
# Tamplate Project - iOS BeIn-BeOut-AMCO

This README file provides a step-by-step guide to set up and customize the BeIn-BeOut-AMCO Project, which serves as a basic template for building iOS apps. By cloning this project and following the instructions in this file, developers can easily configure their own iOS app.



## Project Details

- Xcode Version: 14.3
- Minimum Deployment Version: 14.0
- Localization: Enabled (English by default, additional languages can be added following the process described in this [article](https://medium.com/swlh/app-localization-in-swift-ios-swift-guide-baa2c2e4298e))
- Version Number: 0.1
- Build Number: 0


## Read Me File Instruction

#### Note: This readme file is a template and should be deleted before finalizing the project.
- Please make sure to replace this readme file with a customized one that is specific to your project. Include relevant information, instructions, and guidelines that are applicable to your project's development and usage.

## Project Name Update in SwiftLint Configuration
#### The swiftlint.yml file contains the configuration settings for SwiftLint in your project. To update the project name in the swiftlint.yml file, follow the steps below:

#### 1. Locate the swiftlint.yml file in your project directory.

#### 2. Open the swiftlint.yml file in a text editor.

#### 3. Replace all occurrences of "BeIn-BeOut-AMCO" (the placeholder project name) with the name of your actual project or folder name, based on your project's directory structure. 

## Project Setup

After cloning the project, follow the steps below to customize it for your specific requirements:

#### - App Name
Rename the app by changing the display name in the project's Info.plist file:Open Info.plist in Xcode.
Modify the value of the CFBundleDisplayName key with your desired app name.

#### - AppIcon
Replace the default app icon located in the Assets folder with your own project-specific app icon. Ensure that the new icon has a resolution of 1024x1024 pixels.

#### - Launch Screen Image
Update the `ic_launch_screen_image` file in the Image folder of the Assets section. This will change the launch screen image that appears when the app starts.

#### - Adjust Project Settings
Open the project in Xcode and modify the following settings in the Project Settings according to your project requirements: 
- Add permissions for your app. [Don't forget to include the declaration of the permission message in the localized file of app.(infoPlist.string fils)]
- Include the necessary capabilities based on the requirements of your app.

#### - Google Info.plist
If your application integrates with Google services, you need to provide the necessary configuration in the GoogleService-Info.plist file.
Replace the existing GoogleService-Info.plist file with your own file.
Make sure to update the bundle identifier and any other relevant information required by your Google services.

#### - Other Customizations
- Review the existing todos in the project and make the necessary changes accordingly.
- Review and modify other project files and configurations as needed.
- Update the bundle identifier to match your app's bundle identifier.
- Modify the app's target settings, such as deployment target, signing certificates, etc.
- Update the app's UI and functionality according to your project requirements.
- Minimum Deployment Version: Update the minimum deployment version to match your target audience and compatibility needs.
- Orientation: Choose the desired orientation options (portrait, landscape, etc.) for your app.
- Project Name: Rename the project to reflect the name of your app.
- Certificates and Provisioning Profiles: Configure the appropriate certificates and provisioning profiles for your app's distribution and deployment needs.

Build and run the application in the simulator or on a physical device to verify that all the changes have been applied correctly.

Once you have completed these steps, you can proceed with customizing and developing your iOS app based on the BeIn-BeOut-AMCO Project template.

For additional guidance and information, please refer to the documentation and resources available in the project repository.
