//
//  AppFont.swift
//  SwiftUI-Master-Project
//
//  Created by Trup's Macbook on 05/09/23.
//

import Foundation

enum CustomDialogStyle {
    case alert
    case input
}

struct CustomDialogViewModel {
    var title: String
    let content: String
    let style: CustomDialogStyle
    let inputFieldPlaceholder: String
    let attributedContent: NSMutableAttributedString?
    let negativeButtonText: String
    let neutralButtonText: String
    let positiveButtonText: String
    let onTapNegativeButton: (() -> (()))?
    let onTapNeutralButton: (() -> (()))?
    let onTapPositiveButton: (() -> (()))?
    let onInputValidation: ((String) -> (()))?
    var hasContent: Bool {
        content.isNotEmpty || attributedContent?.string.isNotEmpty ?? false
    }
    init(title: String,
         content: String = "",
         attributedContent: NSMutableAttributedString? = nil,
         inputFieldPlaceholder: String = "",
         negativeButtonText: String = "",
         onTapNegativeButton: (() -> (()))? = nil,
         neutralButtonText: String = "",
         onTapNeutralButton: (() -> (()))? = nil,
         positiveButtonText: String = "",
         onTapPositiveButton: (() -> (()))? = nil,
         onInputValidation: ((String) -> (()))? = nil,
         style: CustomDialogStyle = .alert) {
        self.title = title
        self.style = style
        self.content = content
        self.attributedContent = attributedContent
        self.negativeButtonText = negativeButtonText
        self.neutralButtonText = neutralButtonText
        self.positiveButtonText = positiveButtonText
        self.onTapNegativeButton = onTapNegativeButton
        self.onTapNeutralButton = onTapNeutralButton
        self.onTapPositiveButton = onTapPositiveButton
        self.inputFieldPlaceholder = inputFieldPlaceholder
        self.onInputValidation = onInputValidation
    }
}
