//
//  AppFont.swift
//  SwiftUI-Master-Project
//
//  Created by Trup's Macbook on 05/09/23.
//

import UIKit

class CustomDialog: UIViewController, UIGestureRecognizerDelegate {

    // MARK: - Properties
    @IBOutlet var containerView: UIView!
    @IBOutlet var titleLabel: UILabel!
    @IBOutlet var contentLabel: UILabel!
    @IBOutlet var negativeButton: UIButton!
    @IBOutlet var neutralButton: UIButton!
    @IBOutlet var positiveButton: UIButton!
    private var viewModel: CustomDialogViewModel

    // MARK: - Init View
    init(viewModel: CustomDialogViewModel) {
        self.viewModel = viewModel
        super.init(nibName: "CustomDialog", bundle: nil)
    }

    required init?(coder: NSCoder) {
        self.viewModel = CustomDialogViewModel(title: "")
        super.init(coder: coder)
    }

    // MARK: - VC Life Cycle
    override func viewDidLoad() {
        super.viewDidLoad()
        setupViews()
        populateData()
    }

    // MARK: - Functions
    private func setupViews() {
        styleButtons()
        containerView.layer.cornerRadius = 15
       // contentLabel.font = AppFont.font(type: .regular, size: 13.0)

        let tapGesture = UITapGestureRecognizer(target: self, action: #selector(dismissView))
        tapGesture.cancelsTouchesInView = true
        tapGesture.delegate = self
        view.addGestureRecognizer(tapGesture)
    }

    private func styleButtons() {
        negativeButton.setTitleColor(.colorPrimary, for: .normal)
        neutralButton.setTitleColor(.colorPrimary, for: .normal)
        positiveButton.setTitleColor(.colorPrimary, for: .normal)
        negativeButton.titleLabel?.font = AppFont.font(type: .bold, size: .subTitleFont)
        neutralButton.titleLabel?.font = AppFont.font(type: .bold, size: .subTitleFont)
        positiveButton.titleLabel?.font = AppFont.font(type: .bold, size: .subTitleFont)
    }

    private func populateData() {
        titleLabel.text = viewModel.title
        if let attributedContent = viewModel.attributedContent, attributedContent.string.isNotEmpty {
            contentLabel.attributedText = attributedContent
        } else {
            contentLabel.text = viewModel.content
        }

        negativeButton.setTitle(viewModel.negativeButtonText.uppercased(), for: .normal)
        neutralButton.setTitle(viewModel.neutralButtonText.uppercased(), for: .normal)
        positiveButton.setTitle(viewModel.positiveButtonText.uppercased(), for: .normal)
        negativeButton.addTarget(self, action: #selector(onTapNegativeButtonEvent), for: .touchUpInside)
        neutralButton.addTarget(self, action: #selector(onTapNeutralButtonEvent), for: .touchUpInside)
        positiveButton.addTarget(self, action: #selector(onTapPositiveButtonEvent), for: .touchUpInside)
    }

    // MARK: - Actions
    @objc private func dismissView() {
        dismiss(animated: true)
    }

    @objc private func onTapNegativeButtonEvent() {
        viewModel.onTapNegativeButton?()
    }

    @objc private func onTapNeutralButtonEvent() {
        guard let onTapNeutralButton = viewModel.onTapNeutralButton else { return }
        onTapNeutralButton()
    }

    @objc private func onTapPositiveButtonEvent() {
        if viewModel.style == .alert {
            guard let onTapPositiveButton = viewModel.onTapPositiveButton else { return }
            onTapPositiveButton()
        }
    }

    internal func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view?.isDescendant(of: self.containerView) == true {
            return false
        }
        return true
    }
}
