//
//  ClearBackgroundView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import Foundation
import SwiftUI

struct BackgroundClearView: UIViewRepresentable {
    func makeUIView(context: Context) -> UIView {
        let view = UIView()
        DispatchQueue.main.async {
            view.superview?.superview?.backgroundColor = .primaryBlack.withAlphaComponent(0.1)
        }
        return view
    }

    func updateUIView(_ uiView: UIView, context: Context) {}
}
