//
//  BannerAlert.swift

import UIKit

class BannerAlert {
    var isBannerMessageVisible: Bool = false
    var viewBannerMessage: UIView!
    var appSceneDelegate: AnyObject!
    var directionOfAnimation: DirectionOfAnimation = .fromBottom
    let bannerTag: Int = 100

    init() {
        if #available(iOS 13.0, *) {
            appSceneDelegate = UIApplication.shared.windows.first?.windowScene?.delegate as! SceneDelegate // swiftlint:disable:this force_cast
            // view.window?.windowScene?.delegate as! SceneDelegate
        } else {
            appSceneDelegate = UIApplication.shared.delegate as! AppDelegate // swiftlint:disable:this force_cast
        }
    }

    // MARK: - Methods

    // Banner Message
    @objc func showBannerMessage(message: String, type: Int, showDismissBtn: Int) {
        guard message.isNotEmpty else { return }
        if isBannerMessageVisible {
            // If banner message is already present then returning call so that only one banner message will be displayed at a time.

            viewBannerMessage.removeFromSuperview()
            // return
        }
        var showDismissBtnBool = false
        (showDismissBtn == 1) ? (showDismissBtnBool = true) : (showDismissBtnBool = false)

        isBannerMessageVisible = true

        viewBannerMessage = appSceneDelegate.window?.viewWithTag(bannerTag)

        if viewBannerMessage != nil {
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(showBannerMessage), object: nil)
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(hideBannerMessage), object: nil)

            viewBannerMessage.removeFromSuperview()
            viewBannerMessage.isHidden = true
        }

        viewBannerMessage = UIView()
        viewBannerMessage.tag = bannerTag

        switch type {
        case BannerMessageType.success.rawValue:
            viewBannerMessage.backgroundColor = .bannerMsgSuccess

        case BannerMessageType.failure.rawValue:
            viewBannerMessage.backgroundColor = .bannerMsgFailure
        case BannerMessageType.warning.rawValue:
            viewBannerMessage.backgroundColor = UIColor.primaryBlack

        default:
            viewBannerMessage.backgroundColor = .bannerMsgSuccess
        }

        // Shadow
        viewBannerMessage.layer.shadowColor = UIColor.lightGray.cgColor
        viewBannerMessage.layer.shadowOffset = CGSize(width: 0, height: 1)
        viewBannerMessage.layer.shadowOpacity = 1.0
        viewBannerMessage.layer.shadowRadius = 1.0
        appSceneDelegate.window?.addSubview(viewBannerMessage)

        // Adding label which will display text.
        let lblMessage = UILabel()
        lblMessage.text = message
        lblMessage.textColor = UIColor.white
        // lblMessage.font = UIFont(name: ROBOTO_REGULAR_FONT, size: 17)!
        lblMessage.font = UIFont.systemFont(ofSize: 17)

        var widthLblMessage: CGFloat = 0
        var labelSize: CGSize
        var numOfLines = 0
        var accessibilityHint = ""

        // To display text in multiple lines
        lblMessage.numberOfLines = 0
        lblMessage.lineBreakMode = NSLineBreakMode.byTruncatingTail

        let leadingSpace1: CGFloat = 10
        // let LEADING_SPACE2: CGFloat = 11
        let leadingSpace3: CGFloat = 14
        let leadingSpace4: CGFloat = 30
        let bannerSpace: CGFloat = 46

        // Label & button, both will be added into banner.
        if showDismissBtnBool {
            // Setting frame of label
            lblMessage.textAlignment = NSTextAlignment.left

            let btnwidth: CGFloat = 90
            widthLblMessage = UIScreen.main.bounds.width - btnwidth - (leadingSpace4 * 2)
            labelSize = getRectForText(message: lblMessage.text!, font: lblMessage.font,
                                       maxSize: CGSize(width: widthLblMessage, height: CGFloat.greatestFiniteMagnitude))
            // Same as header
            lblMessage.frame = CGRect(x: leadingSpace4, y: leadingSpace1 * 2, width: widthLblMessage, height: labelSize.height)

            viewBannerMessage.addSubview(lblMessage)

            numOfLines = Int(labelSize.height / lblMessage.font.pointSize)

            // Same as header
            if directionOfAnimation == DirectionOfAnimation.fromTop {
                viewBannerMessage.frame = CGRect(x: 0,
                                                 y: 0,
                                                 width: UIScreen.main.bounds.width,
                                                 height: ceil(lblMessage.frame.size.height + bannerSpace))
            } else {
                viewBannerMessage.frame = CGRect(x: 0,
                                                 y: UIScreen.main.bounds.height,
                                                 width: UIScreen.main.bounds.width,
                                                 height: ceil(lblMessage.frame.size.height + bannerSpace))
            }

            accessibilityHint = String(format: "%f", lblMessage.frame.size.height + bannerSpace)

            // Adding dismiss button
            let btnDismiss = UIButton()
            btnDismiss.setTitle(NSLocalizedString("ok", comment: "").uppercased(), for: UIControl.State.normal)
            btnDismiss.setTitleColor(UIColor.white, for: UIControl.State.normal)
            btnDismiss.setTitleColor(UIColor.white, for: UIControl.State.highlighted)
            // btnDismiss.titleLabel?.font = UIFont(name: ROBOTO_REGULAR_FONT, size: 14)!
            btnDismiss.titleLabel?.font = UIFont.systemFont(ofSize: 14)
            btnDismiss.frame = CGRect(x: UIScreen.main.bounds.width - leadingSpace4 - btnwidth, y: lblMessage.frame.origin.y,
                                      width: btnwidth, height: labelSize.height)
            btnDismiss.accessibilityHint = accessibilityHint
            btnDismiss.contentHorizontalAlignment = UIControl.ContentHorizontalAlignment.right
            btnDismiss.addTarget(self, action: #selector(btnCloseBannerMsgClicked(sender:)), for: UIControl.Event.touchUpInside)

            viewBannerMessage.addSubview(btnDismiss)
            appSceneDelegate.window?.isUserInteractionEnabled = true
        } // Only label will be added into banner.
        else {
            lblMessage.textAlignment = NSTextAlignment.center

            // Seting frame of label
            widthLblMessage = UIScreen.main.bounds.width - (leadingSpace3 * 2)
            labelSize = getRectForText(message: lblMessage.text!, font: lblMessage.font,
                                       maxSize: CGSize(width: widthLblMessage, height: CGFloat.greatestFiniteMagnitude))

            lblMessage.frame = CGRect(x: leadingSpace3, y: leadingSpace1 * 2, width: widthLblMessage, height: labelSize.height)
            viewBannerMessage.addSubview(lblMessage)

            numOfLines = Int(labelSize.height / lblMessage.font.pointSize)
            if directionOfAnimation == DirectionOfAnimation.fromTop {
                viewBannerMessage.frame = CGRect(x: 0,
                                                 y: 0,
                                                 width: UIScreen.main.bounds.width,
                                                 height: ceil(lblMessage.frame.size.height + bannerSpace))
            } else {
                viewBannerMessage.frame = CGRect(x: 0,
                                                 y: UIScreen.main.bounds.height,
                                                 width: UIScreen.main.bounds.width,
                                                 height: ceil(lblMessage.frame.size.height + bannerSpace))
            }

            accessibilityHint = String(format: "%f", lblMessage.frame.size.height + bannerSpace)
            appSceneDelegate.window?.isUserInteractionEnabled = true
        }

        UIView.animate(withDuration: 0.5, delay: 0, options: [.curveEaseOut], animations: {
            var frame = self.viewBannerMessage.frame
            if self.directionOfAnimation == DirectionOfAnimation.fromTop {
                frame.origin.y = -(lblMessage.frame.size.height + bannerSpace)
            } else {
                frame.origin.y = UIScreen.main.bounds.height - (lblMessage.frame.size.height + bannerSpace)
            }

            self.viewBannerMessage.frame = frame
        }, completion: { (_: Bool) in
            if !showDismissBtnBool {
                //                DispatchQueue.main.asyncAfter(deadline: .now() + TimeInterval(ceil(Double(numOfLines) * HIDE_BANNER_ANIM_DUR))) {
                //                    self.hideBannerMessage()
                //                }

                DispatchQueue.main.asyncAfter(deadline: .now() + TimeInterval(ceil(Double(numOfLines) * 1.5))) {
                    self.hideBannerMessage()
                }
            }
        })
    }

    @objc func hideBannerMessage() {
        UIView.animate(withDuration: Constant.bannerAnimationDuration, delay: 0, options: [.curveEaseOut], animations: {
            var frame = self.viewBannerMessage.frame
            if self.directionOfAnimation == DirectionOfAnimation.fromTop {
                frame.origin.y = 0
            } else {
                frame.origin.y = UIScreen.main.bounds.height
            }
            self.viewBannerMessage.frame = frame
        }, completion: { (value: Bool) in
            if value {
                // Removing banner from super view
                self.viewBannerMessage.isHidden = true
                self.viewBannerMessage.removeFromSuperview()

                self.isBannerMessageVisible = false
            }
        })
    }

    // Get frame size of banner according to message.
    func getRectForText(message: String, font: UIFont, maxSize: CGSize) -> CGSize {
        let rect = NSAttributedString(string: message, attributes: [NSAttributedString.Key.font: font])
            .boundingRect(with: maxSize, options: NSStringDrawingOptions.usesLineFragmentOrigin, context: nil)
        return CGSize(width: rect.size.width, height: rect.size.height)
    }

    // Click event of dismiss button of banner view.
    @objc func btnCloseBannerMsgClicked(sender _: UIButton) {
        hideBannerMessage()
    }
}
