import UIKit

extension String {
//    var unescaped: String {
//           let entities = ["\0", "\t", "\n", "\r", "\"", "\'", "\\"]
//           var current = self
//           for entity in entities {
//               let descriptionCharacters = entity.debugDescription.dropFirst().dropLast()
//               let description = String(descriptionCharacters)
//               current = current.replacingOccurrences(of: description, with: entity)
//           }
//           return current
//       }
    func decodeHex() -> String? {
           guard self.count % 2 == 0 else {
               preconditionFailure("Must have an even length")
           }

           var bytes: [UInt8] = []
           var index = self.startIndex

           while index < self.endIndex {
               let hexByte = String(self[index ..< self.index(index, offsetBy: 2)])
               if let byte = UInt8(hexByte, radix: 16) {
                   bytes.append(byte)
               } else {
                   return nil // Invalid hex digit
               }

               index = self.index(index, offsetBy: 2)
           }

           return String(bytes: bytes, encoding: .utf8)
       }
    var floatValue: Float {
        return (self as NSString).floatValue
    }

    var doubleValue: Double {
        return (self as NSString).doubleValue
    }

    var intValue: Int {
        return (self as NSString).integerValue
    }

    var boolValue: Bool {
        return (self as NSString).boolValue
    }

    var localized: String {
        return NSLocalizedString(self, comment: "")
    }

    var isNotEmpty: Bool {
        !isEmpty
    }

    func trim() -> String {
        if self == "null" || self == "<null>" || self == "(null)" {
            return ""
        }
        else {
            return trimmingCharacters(in: .whitespacesAndNewlines)
        }
    }

    func encoding() -> String {
        // return self.addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed)!
        let allowedCharacterSet = (CharacterSet(charactersIn: "!*'();:@&=+$,/?%#[]<> ").inverted)
        return addingPercentEncoding(withAllowedCharacters: allowedCharacterSet) ?? ""
    }

    func decoding() -> String {
        return removingPercentEncoding ?? ""
    }

    func htmlToString() -> String {
        let data = Data(utf8)
        if let attributedString = try? NSAttributedString(data: data, options: [.documentType: NSAttributedString.DocumentType.html], documentAttributes: nil) {
            return attributedString.string
        }
        else {
            return self
        }
    }

    func containsNumbers() -> Bool {
        let numberRegEx = ".*[0-9]+.*"
        let testCase = NSPredicate(format: "SELF MATCHES %@", numberRegEx)
        return testCase.evaluate(with: self)
    }

    /* func localized() -> String {
     var lang = SessionManager.getStringSession(key: SESSION_KEY_SELECTED_LOCALIZABLE)
     if lang.isEmpty {
     lang = "en"
     }
     let path = Bundle.main.path(forResource: lang, ofType: "lproj")
     let bundle = Bundle(path: path!)

     return NSLocalizedString(self, tableName: nil, bundle: bundle!, value: "", comment: "")
     } */
    func width(withConstrainedHeight height: CGFloat, font: UIFont) -> CGFloat {
        let constraintRect = CGSize(width: .greatestFiniteMagnitude, height: height)
        let boundingBox = self.boundingRect(with: constraintRect, options: .usesLineFragmentOrigin, attributes: [.font: font], context: nil)
        return ceil(boundingBox.width)
    }

    func sizeOf(_ font: UIFont) -> CGSize {
        return self.size(withAttributes: [.font: font])
    }

    func height(withConstrainedWidth width: CGFloat, font: UIFont) -> CGFloat {
        let constraintRect = CGSize(width: width, height: .greatestFiniteMagnitude)
        let boundingBox = self.boundingRect(with: constraintRect, options: .usesLineFragmentOrigin, attributes: [NSAttributedString.Key.font: font], context: nil)
        return ceil(boundingBox.height)
    }

    var htmlToAttributedString: NSAttributedString? {
        guard let data = data(using: .utf8) else { return nil }
        do {
            return try NSAttributedString(data: data, options: [.documentType: NSAttributedString.DocumentType.html, .characterEncoding: String.Encoding.utf8.rawValue], documentAttributes: nil)
        }
        catch {
            return nil
        }
    }

    func hashtags(withHash: Bool = false) -> [String] {
        // Allow English and Thai characters
        if let regex = try? NSRegularExpression(pattern: "#[A-Za-z0-9\u{0E00}-\u{0E7F}]+", options: .caseInsensitive) {
            let string = self as NSString
            if withHash {
                return regex.matches(in: self, options: [], range: NSRange(location: 0, length: string.length)).map {
                    string.substring(with: $0.range).lowercased()
                }
            }
            else {
                return regex.matches(in: self, options: [], range: NSRange(location: 0, length: string.length)).map {
                    string.substring(with: $0.range).replacingOccurrences(of: "#", with: "").lowercased()
                }
            }
        }
        return []
    }

    func strikeThrough() -> NSAttributedString {
        let attributeString = NSMutableAttributedString(string: self)
        attributeString.addAttribute(NSAttributedString.Key.strikethroughStyle,
                                     value: NSUnderlineStyle.single.rawValue,
                                     range: NSRange(location: 0, length: attributeString.length))
        return attributeString
    }

    func isNumberOnly() -> Bool {
        let allowedCharacters = CharacterSet(charactersIn: "0123456789") // Here change this characters based on your requirement
        let characterSet = CharacterSet(charactersIn: self)
        return allowedCharacters.isSuperset(of: characterSet)
    }

    func isNumberOnlyDecimal() -> Bool {
        let allowedCharacters = CharacterSet(charactersIn: "0123456789.") // Here change this characters based on your requirement
        let characterSet = CharacterSet(charactersIn: self)
        return allowedCharacters.isSuperset(of: characterSet)
    }

    func capitalizingFirstLetter() -> String {
        return prefix(1).uppercased() + lowercased().dropFirst()
    }

    mutating func capitalizeFirstLetter() {
        self = capitalizingFirstLetter()
    }

    func getDate() -> Date? {
        let dateFormatter = DateFormatter()
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss" // "dd MMM yyyy hh:mm a"
        if let date = dateFormatter.date(from: self) {
            return date
        }
        else {
            dateFormatter.dateFormat = "yyyy-MM-dd"
            if let date = dateFormatter.date(from: self) {
                return date
            }
        }
        return nil
    }

    func index(from: Int) -> Index {
        return index(startIndex, offsetBy: from)
    }

    func substring(from: Int) -> String {
        let fromIndex = index(from: from)
        return String(self[fromIndex...])
    }

    func substring(strString: Int) -> String {
        let toIndex = index(from: strString)
        return String(self[..<toIndex])
    }

    func substring(with strString: Range<Int>) -> String {
        let startIndex = index(from: strString.lowerBound)
        let endIndex = index(from: strString.upperBound)
        return String(self[startIndex ..< endIndex])
    }
}

extension Optional {
    func unwrapped<T>(or defaultValue: T) -> T {
        if let value = self as? T {
            return value
        }
        return defaultValue
    }
}
