//
//  UIAlertController.swift
//

import Foundation
import UIKit

extension UIAlertController {
    func presentActionSheetVideoSetting(title: String?, message: String?, qualityActionHandler: ((UIAlertAction) -> Void)? = nil, scaleActionHandler: ((UIAlertAction) -> Void)? = nil, playBackActionHandler: ((UIAlertAction) -> Void)? = nil, captionActionHandler: ((UIAlertAction) -> Void)? = nil, cancelActionHandler: ((UIAlertAction) -> Void)? = nil) {
        let actionSheet = UIAlertController(title: title, message: message, preferredStyle: .actionSheet)

        let okAction = UIAlertAction(title: "quality".localized, style: .default, handler: qualityActionHandler)
        let scaleAction = UIAlertAction(title: "scale".localized, style: .default, handler: scaleActionHandler)
        let playbackSpeedAction = UIAlertAction(title: "playback_speed".localized, style: .default, handler: playBackActionHandler)
        let captionAction = UIAlertAction(title: "caption".localized, style: .default, handler: captionActionHandler)

        let cancelAction = UIAlertAction(title: "cancel".localized, style: .cancel, handler: cancelActionHandler)

        actionSheet.addAction(okAction)
        actionSheet.addAction(scaleAction)
        actionSheet.addAction(playbackSpeedAction)
        actionSheet.addAction(captionAction)
        actionSheet.addAction(cancelAction)

        present(actionSheet, animated: true, completion: nil)
    }
}
