//
//  DateUtilities.swift
//
//
//

import UIKit

struct DateUtilities {
    // MARK: - Date formates

    /// Get date string from one format to another format
    /// - Parameter dateString: DateString to be converted
    /// - Parameter oldFormat: DateString's date format
    /// - Parameter newFormat: Expected date format for o/p String
    ///
    /// - Returns: date-time string in newFormate
    static func formatDateToString(dateString: String, fromFormat oldFormat: String, toFormat newFormat: String) -> String? {
        if dateString.isEmpty {
            return nil
        }

        let dateFormateOfServer = DateFormatter()
        dateFormateOfServer.locale = Locale(identifier: "en_US")
        dateFormateOfServer.dateFormat = oldFormat

        let dateFormateToShow = DateFormatter()
        dateFormateToShow.locale = Locale(identifier: "en_US")
        dateFormateToShow.dateFormat = newFormat

        if let date = dateFormateOfServer.date(from: dateString) {
            return dateFormateToShow.string(from: date)
        } else {
            return nil
        }
    }

    /// Get date string from given Date
    /// - Parameter date: Date
    /// - Parameter newFormat: Expected date format for o/p String
    ///
    /// - Returns: date-time string in newFormate
    static func formatDateToString(date: Date, toFormat newFormat: String) -> String? {
        // Converts Date to required date format in String
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = newFormat
        dateFormatter.locale = NSLocale.current
        return dateFormatter.string(from: date)
    }

    /// Get date string from given Date
    /// - Parameter dateString: DateString to be converted
    /// - Parameter oldFormat: DateString's date format
    /// - Parameter newFormat: Expected date format for o/p String
    /// - Parameter amSymbol: am format for o/p String
    /// - Parameter pmSymbol: pm format for o/p String
    ///
    /// - Returns: date-time string in newFormate
    static func formatDateToString(dateString: String, fromFormat oldFormat: String, toFormat newFormat: String, amSymbol: String, pmSymbol: String) -> String? {
        if dateString.isEmpty {
            return nil
        }

        let dateFormateOfServer = DateFormatter()
        dateFormateOfServer.locale = Locale(identifier: "en_US")
        dateFormateOfServer.dateFormat = oldFormat

        let dateFormateToShow = DateFormatter()
        dateFormateToShow.locale = Locale(identifier: "en_US")
        dateFormateToShow.dateFormat = newFormat
        dateFormateToShow.amSymbol = amSymbol
        dateFormateToShow.pmSymbol = pmSymbol

        if let date = dateFormateOfServer.date(from: dateString) {
            return dateFormateToShow.string(from: date)
        } else {
            return nil
        }
    }

    /// Get current date-time in seconds.
    /// - Returns: Current date-time in seconds.
    static func getCurrentSeconds() -> Double {
        return Double(Date().timeIntervalSince1970)
    }

    // MARK: 102.21: Get Current Milies

    /// Get current date-time in millis.
    /// - Returns: Current date-time in millis.
    static func getCurrentMillis() -> Double {
        return Double(Date().timeIntervalSince1970 * 1000)
    }

    // MARK: 102.24: Get Current Milies

    /// Get date-time in millis.
    /// - Returns: date-time in millis.
    static func getMillis(from date: Date) -> Double {
        return Double(date.timeIntervalSince1970 * 1000)
    }

    // MARK: 102.23: Formate Current Milies To String in format: "dd MMM,yyyy hh:mm:ss a"

    /// Get difference of hours between two dates in milies formate
    /// - Parameter milies: date in milies
    /// - Parameter newFormat: Expected date format for o/p String
    ///
    /// - Returns: Date String as per newFormat
    static func formatCurrentMiliesToString(milies: Double, newFormat: String) -> String {
        let date = NSDate(timeIntervalSince1970: Double(milies) / 1000.0)

        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = newFormat
        dateFormatter.timeZone = TimeZone.current

        return dateFormatter.string(from: date as Date)
    }

    // MARK: 102.22: Formate Current Milies To Date in format: "dd MMM,yyyy hh:mm:ss a"

    /// Get difference of hours between two dates in milies formate
    /// - Parameter milies:date in milies
    ///
    /// - Returns: Date from milies
    static func formatCurrentMiliesToDate(milies: Double, format: String) -> Date? {
        let date = NSDate(timeIntervalSince1970: Double(milies) / 1000.0)

        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = format
        dateFormatter.timeZone = TimeZone.current
        let timeStamp = dateFormatter.string(from: date as Date)

        let formatter = DateFormatter()
        formatter.dateFormat = format

        if let date = formatter.date(from: timeStamp) {
            return date
        } else {
            return nil
        }
    }

    // MARK: 102.24: Date string with format "dd MMM, yyyy hh:mm:ss a" To milies

    /// Get Date form the Date string
    /// - Parameter dateString: Date String to be converted
    /// - Parameter oldFormat: dateString's date formate
    ///
    /// - Returns: Date
    static func formatStringToMilies(dateString: String, fromFormat oldFormat: String) -> Double? {
        if let date = DateUtilities.formatStringToDate(dateString: dateString, fromFormat: oldFormat) {
            return DateUtilities.getMillis(from: date)
        } else {
            return nil
        }
    }

    // MARK: 102.25: Get difference of hours between two dates in milies formate (For Master API Call)

    /// Get difference of hours between two dates in milies formate
    /// - Parameter fromDateTime: From date in milies
    /// - Parameter toDateTime: To date in milies
    ///
    /// - Returns: Difference in hours
    static func getHoursFromMillis(fromDateTime: Double, toDateTime: Double) -> Double {
        let diff: Double = (((fromDateTime - toDateTime) / 1000) / 60 / 60)
        debugPrint("Hours \(diff)")

        return diff
    }

    // MARK: 102.26: Get Date form the Date string

    /// Get Date form the Date string
    /// - Parameter dateString: Date String to be converted
    /// - Parameter oldFormat: dateString's date formate
    ///
    /// - Returns: Date
    static func formatStringToDate(dateString: String, fromFormat oldFormat: String) -> Date? {
        if dateString.isEmpty {
            return nil
        }

        let dateFormatter = DateFormatter()
        dateFormatter.locale = Locale(identifier: "en_US")
        dateFormatter.dateFormat = oldFormat

        if let date = dateFormatter.date(from: dateString) {
            return date
        } else {
            return nil
        }
    }

    // MARK: 102.26: Get Date form the Date string

    /// Get Date form the Date string
    /// - Parameter dateString: Date String to be converted
    /// - Parameter oldFormat: dateString's date formate
    ///
    /// - Returns: Date
    static func formatStringToDate2(dateString: String!, fromFormat oldFormat: String!) -> Date? {
        if dateString.isEmpty {
            return nil
        }

        let dateFormatter = DateFormatter()
        dateFormatter.locale = Locale(identifier: "en_US")
        dateFormatter.dateFormat = oldFormat
        dateFormatter.timeZone = Calendar.current.timeZone
        dateFormatter.locale = Calendar.current.locale

        if let date = dateFormatter.date(from: dateString) {
            return date
        } else {
            return nil
        }
    }

    // MARK: 102.27: Difference between current date & date string.

    /// Date Difference
    /// - Parameters:
    ///   - dateString: Date string from
    ///   - sourceFormat: Date format
    ///   - beforePostFix: Before Postfix (ago, before , etc)
    ///   - afterPostFix: After Postfix (after, later, etc)
    ///   -
    /// - Returns: Date differnce string components - second, minute, hour,  day, month, year
    static func dateDifference(dateString: String!,
                               fromFormat sourceFormat: String!,
                               fewPrefix: String = "few",
                               beforePostFix: String = "ago",
                               afterPostFix: String = "after") -> String
    {
        if dateString.isEmpty {
            return ""
        }

        let dateFormateOfServer = DateFormatter()
        dateFormateOfServer.locale = Locale(identifier: "en_US")
        dateFormateOfServer.dateFormat = sourceFormat

        let date = dateFormateOfServer.date(from: dateString)
        let now = NSDate()

        let formatter = DateComponentsFormatter()
        formatter.allowedUnits = [.second, .minute, .hour, .day, .month, .year]
        formatter.unitsStyle = .full
        formatter.maximumUnitCount = 1

        let str = formatter.string(from: date!, to: now as Date)! // Date Differnce String

        var prefix = ""
        var postfix = ""
        var strDateDifference = ""

        if str.components(separatedBy: " ").first?.trim().intValue ?? 0 > 0 {
            postfix = beforePostFix
        } else if str.components(separatedBy: " ").first?.trim().intValue ?? 0 < 0 {
            postfix = afterPostFix
        } else {
            prefix = fewPrefix
            postfix = beforePostFix
        }

        if prefix.isNotEmpty {
            if str.components(separatedBy: " ").count > 1 {
                strDateDifference = String(format: "%@ %@ %@", prefix, (str.components(separatedBy: " "))[1], postfix)
            }
        } else {
            strDateDifference = String(format: "%@ %@", str, postfix)
        }

        return strDateDifference
    }

    // MARK: 102.28: Duration string from minutes

    /// get text from minutes
    /// - Parameter mins: Minutes (i.e 80)
    /// - Returns: Text  (i.e 1 hr 10 mins)
    static func getDurationString(mins: Int) -> String {
        var str = ""

        var dateComponent = DateComponents()
        dateComponent.minute = Int(mins)

        if mins <= 1 {
            str = String(format: "%d min", mins)
        } else if mins > 1 {
            if mins >= 60 {
                if mins % 6 > 0 && mins % 6 == 1 {
                    str = String(format: "%@ hr %@ min", "\(mins / 60)", "\(mins % 60)")
                } else if mins % 6 > 1 {
                    str = String(format: "%@ hr %@ mins", "\(mins / 60)", "\(mins % 60)")
                } else {
                    str = String(format: "%@ hr", "\(mins / 60)")
                }
            } else {
                str = String(format: "%d mins", mins)
            }
        }
        return str
    }

    // MARK: 104.8: get hours from date

    // MARK: - Calender

    /// Get hours from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: hour in Int
    static func getHour(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.hour], from: date).hour
    }

    // MARK: 104.9: get minute from date

    /// Get minutes from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: minutes in Int
    static func getMinute(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.minute], from: date).minute
    }

    // MARK: 104.10: get second from date

    /// Get seconds from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: seconds in Int
    static func getSecond(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.second], from: date).second
    }

    // MARK: 104.13: get year from date

    /// Get year from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: year in Int
    static func getYear(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.year], from: date).year
    }

    // MARK: 104.12: get month from date

    /// Get month from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: month in Int
    static func getMonth(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.month], from: date).month
    }

    // MARK: 104.11: get day from date

    /// Get day from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: day in Int
    static func getDay(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.day], from: date).day
    }

    // MARK: 104.14: get Week of Month from date

    /// Get weekOfMonth from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: weekOfMonth in Int
    static func getWeekOfMonth(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.weekOfMonth], from: date).weekOfMonth
    }

    // MARK: 104.15: get Week Day from date

    /// Get weekday from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: weekday in Int
    static func getWeekDay(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.weekday], from: date).weekday
    }

    // MARK: 104.16: get Week Of Year from date

    /// Get weekOfYear from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: weekOfYear in Int
    static func getWeekOfYear(for date: Date) -> Int? {
        return Calendar.current.dateComponents([.weekOfYear], from: date).weekOfYear
    }

    // MARK: 104.17: get Year For Week Of Year from date

    /// Get yearForWeekOfYear from the Date
    /// - Parameter date: Date
    ///
    /// - Returns: yearForWeekOfYear in Int
    static func yearForWeekOfYear(for date: Date) -> Int {
        return Calendar.current.dateComponents([.yearForWeekOfYear], from: date).yearForWeekOfYear ?? 0
    }

    // MARK: 104.18: Date After Adding month, day and yea

    /// Get Date from the adding month, day, year into given date
    /// - Parameter month: Month
    /// - Parameter day: day
    /// - Parameter year: year
    /// - Parameter date: date
    ///
    /// - Returns: Date
    static func getDateAfterAdding(month: Int, day: Int, year: Int, date: Date) -> Date? {
        var dateComponent = DateComponents()

        dateComponent.month = month
        dateComponent.day = day
        dateComponent.year = year

        if let date = Calendar.current.date(byAdding: dateComponent, to: date) {
            return date
        } else {
            return nil
        }
    }

    // MARK: 103.5.8: Assign textField inputView

    // MARK: - ToolBar TabBarButton

    // MARK: 101.2: Add Method into Utilities

    /// Get UIBarButtonItem
    /// - Parameter style: UIBarButtonItem Button Style
    /// - Parameter selector: Selector method
    /// - Parameter target: UI ViewController
    ///
    /// - Returns: UIBarButtonItem
    static func buttonItem(withSystemItemStyle style: UIBarButtonItem.SystemItem, selector: Selector?, target: BaseViewController) -> UIBarButtonItem {
        let buttonTarget = style == .flexibleSpace ? nil : target
        let action: Selector? = selector
        let barButtonItem = UIBarButtonItem(barButtonSystemItem: style,
                                            target: buttonTarget,
                                            action: action)
        return barButtonItem
    }

    // MARK: - Date based on Range

    static func getDays(selectedDate: Date, previousDaysCount: Int, nextDaysCount: Int) -> [CalenderDay] {
        var arrDays: [CalenderDay] = []

        let calendar = Calendar(identifier: .gregorian)

        var arrPreviousDates = [CalenderDay]()
        var arrNextDates = [CalenderDay]()

        for index in stride(from: previousDaysCount, to: 0, by: -1) {
            let date: Date = calendar.date(byAdding: .day, value: -index, to: selectedDate) ?? selectedDate
            debugPrint("Previous date: \(date)")

            arrPreviousDates.append(CalenderDay(date: date,
                                                number: calendar.dateComponents([.day], from: date).day ?? 0,
                                                isSelected: false,
                                                isDisabled: true,
                                                isCurrentDate: false))
        }

        if nextDaysCount > 0 {
            for index in 1 ... nextDaysCount {
                let date: Date = calendar.date(byAdding: .day, value: index, to: selectedDate) ?? selectedDate
                debugPrint("Next date: \(date)")

                arrNextDates.append(CalenderDay(date: date,
                                                number: calendar.dateComponents([.day], from: date).day ?? 0,
                                                isSelected: false,
                                                isDisabled: true,
                                                isCurrentDate: false))
            }
        }

        arrDays.append(contentsOf: arrPreviousDates)
        arrDays.append(CalenderDay(date: selectedDate,
                                   number: calendar.dateComponents([.day], from: selectedDate).day ?? 0,
                                   isSelected: true,
                                   isDisabled: false,
                                   isCurrentDate: true))
        arrDays.append(contentsOf: arrNextDates)

        return arrDays
    }

    static func getAllDays(selectedDate: Date, minimumDate: Date) -> [CalenderDay] {
        var days = [CalenderDay]()

        let calendar = Calendar.current

        let minDateComponent = calendar.dateComponents([.month, .year, .day], from: minimumDate)
        let selectedDateComponent = calendar.dateComponents([.month, .year, .day], from: selectedDate)
        let currentDateComponent = calendar.dateComponents([.month, .year, .day], from: Date())

        let range = calendar.range(of: .day, in: .month, for: selectedDate)!

        var selectedMonthDate = selectedDate.firstDayOfTheMonth()

        for _ in 1 ... range.count {
            if minDateComponent.month == selectedDateComponent.month, minDateComponent.year == selectedDateComponent.year {
                if calendar.dateComponents([.day], from: selectedMonthDate).day ?? 0 < minDateComponent.day ?? 0 {
                    days.append(CalenderDay(date: selectedMonthDate,
                                            number: calendar.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                            isSelected: false,
                                            isDisabled: true,
                                            isCurrentDate: false))
                } else {
                    if calendar.dateComponents([.day], from: selectedMonthDate).day ?? 0 == minDateComponent.day ?? 0 {
                        days.append(CalenderDay(date: selectedMonthDate,
                                                number: Calendar.current.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                                isSelected: true,
                                                isDisabled: false,
                                                isCurrentDate: false))
                    } else {
                        days.append(CalenderDay(date: selectedMonthDate,
                                                number: Calendar.current.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                                isSelected: false,
                                                isDisabled: false,
                                                isCurrentDate: false))
                    }
                }
            } else {
                if calendar.dateComponents([.day], from: selectedMonthDate).day ?? 0 == currentDateComponent.day, calendar.dateComponents([.month], from: selectedMonthDate).month ?? 0 == currentDateComponent.month {
                    days.append(CalenderDay(date: selectedMonthDate,
                                            number: Calendar.current.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                            isSelected: true,
                                            isDisabled: false,
                                            isCurrentDate: true))
                } else if calendar.dateComponents([.day], from: selectedMonthDate).day ?? 0 == 1, calendar.dateComponents([.month], from: selectedMonthDate).month ?? 0 != currentDateComponent.month {
                    days.append(CalenderDay(date: selectedMonthDate,
                                            number: Calendar.current.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                            isSelected: true,
                                            isDisabled: false,
                                            isCurrentDate: false))
                } else {
                    days.append(CalenderDay(date: selectedMonthDate,
                                            number: Calendar.current.dateComponents([.day], from: selectedMonthDate).day ?? 0,
                                            isSelected: false,
                                            isDisabled: false,
                                            isCurrentDate: false))
                }
            }

            selectedMonthDate.addDays(values: 1)
        }

        return days
    }

    // MARK: - AttrinutedString

    static func getAttributedString(textAlignment: NSTextAlignment,
                                    message: String,
                                    lineSpacing: CGFloat = 1,
                                    messageFont: UIFont,
                                    messageTextColor: UIColor,
                                    arrAttributes: [AttributedString]) -> NSMutableAttributedString
    {
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = lineSpacing
        paragraphStyle.alignment = textAlignment

        let mutableStringTitle = NSMutableAttributedString(string: message,
                                                           attributes: [NSAttributedString.Key.font: messageFont,
                                                                        NSAttributedString.Key.paragraphStyle: paragraphStyle,
                                                                        NSAttributedString.Key.foregroundColor: messageTextColor])

        for index in 0 ..< arrAttributes.count {
            if let range = message.range(of: arrAttributes[index].subString) {
                if arrAttributes[index].attributeType != nil {
                    mutableStringTitle.addAttribute(arrAttributes[index].attributeType,
                                                    value: arrAttributes[index].subString,
                                                    range: NSRange(range, in: message))
                }

                let startPos = message.distance(from: message.startIndex, to: range.lowerBound)

                if arrAttributes[index].isUnderlined {
                    mutableStringTitle.addAttributes([NSAttributedString.Key.font: arrAttributes[index].subStringFont,
                                                      NSAttributedString.Key.foregroundColor: arrAttributes[index].subStringColor,
                                                      NSAttributedString.Key.underlineStyle: arrAttributes[index].underlineStyle,
                                                      NSAttributedString.Key.underlineColor: arrAttributes[index].underlineColor],
                                                     range: NSRange(location: startPos, length: arrAttributes[index].subString.count))

                } else if arrAttributes[index].isStrikeThrough {
                    mutableStringTitle.addAttributes([NSAttributedString.Key.font: arrAttributes[index].subStringFont,
                                                      NSAttributedString.Key.foregroundColor: arrAttributes[index].subStringColor,
                                                      NSAttributedString.Key.strikethroughStyle: NSUnderlineStyle.single.rawValue],
                                                     range: NSRange(location: startPos, length: arrAttributes[index].subString.count))

                } else {
                    mutableStringTitle.addAttributes([NSAttributedString.Key.font: arrAttributes[index].subStringFont,
                                                      NSAttributedString.Key.foregroundColor: arrAttributes[index].subStringColor],
                                                     range: NSRange(location: startPos, length: arrAttributes[index].subString.count))
                }
            }
        }

        return mutableStringTitle
    }

    static func formattedDate(fromUnixTimestamp unixTimestamp: Int) -> String {
        let date = Date(timeIntervalSince1970: TimeInterval(unixTimestamp))
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "MMMM d, h:mm a"
        return "Muted until " + dateFormatter.string(from: date)
    }
}

struct CalenderDay {
    var date: Date
    var number: Int
    var isSelected: Bool
    var isDisabled: Bool
    var isCurrentDate: Bool
}
