//
//  DateExt.swift
//

import Foundation

extension Date {
    mutating func addDays(values: Int) {
        let cal = Calendar.current
        self = cal.date(byAdding: .day, value: values, to: self)!
    }

    func firstDayOfTheMonth() -> Date {
        return Calendar.current.date(from: Calendar.current.dateComponents([.year, .month], from: self))!
    }

    func utcToLocal() -> String? {
        let dateFormatter = DateFormatter()
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "dd MMM yyyy hh:mm a"
        return dateFormatter.string(from: self)
    }

    func getYear() -> String? {
        let dateFormatter = DateFormatter()
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "yyyy"
        return dateFormatter.string(from: self)
    }

    func convertDateFormate(strDate: String) -> String {
        let inputFormatter = DateFormatter()
        inputFormatter.dateFormat = "MM-dd-yyyy"
        let showDate = inputFormatter.date(from: strDate)
        inputFormatter.dateFormat = "yyyy-MM-dd"
        let resultString = inputFormatter.string(from: showDate!)
        return resultString
    }

    func convertBirthDateFormate(strDate: String) -> String {
        let inputFormatter = DateFormatter()
        inputFormatter.dateFormat = "yyyy-MM-dd"
        let showDate = inputFormatter.date(from: strDate)
        inputFormatter.dateFormat = "MM-dd-yyyy"
        let resultString = inputFormatter.string(from: showDate!)
        return resultString
    }
}
