//
//  AppURL.swift
//

import Foundation

struct AppURL {
    static var baseUrl: String {
        guard let infoDictionary = Bundle.main.infoDictionary,
              let baseUrl = infoDictionary["BASE_URL"] as? String else
        {
            return "https://ktelbus.gr/bibo-dev/amfare-admin/" // Incase of failure, using prod base url.
        }
        return baseUrl
    }

    enum API {
        private static let baseUrl = AppURL.baseUrl+"web/api/be_in_be_out/"
        static let login = baseUrl + "auth/login_user"
        static let loginCustomer = baseUrl + "auth/login_customer"
        static let event = baseUrl + "event"
        static let events = baseUrl + "events"
    }
}
