//
//  SignUpView.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct SignUpView: View {
//    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>
    @State private var firstName = ""
    @State private var lastName = ""
    @State private var email = ""
    @State private var password = ""
    @State private var confirmPassword = ""
    var viewModel: SignUpViewModel

    var spacer20: some View {
            Spacer().frame(height: 20)
        }

    var body: some View {
        VStack {
            HeaderView(title: "signup".localized, headerBackgroundColor: Color.clear, titleColor: Color.primaryBlack, onBackTapped: {
//                self.presentationMode.wrappedValue.dismiss()
                viewModel.onTapBack?()
            })
            ScrollView {
                VStack {
                    SingleLineTextField(placeHolder: "first_name".localized, text: $firstName, onChangeText: { updatedText in
                        debugPrint("Updated text: \(updatedText)")
    //                    email = updatedText
                    })
                    Spacer().frame(height: 20)
                    SingleLineTextField(placeHolder: "last_name".localized, text: $lastName, onChangeText: { updatedText in
                        debugPrint("Updated text: \(updatedText)")
    //                    email = updatedText
                    })
                    Spacer().frame(height: 20)
                    SingleLineTextField(placeHolder: "email".localized, text: $email, onChangeText: { updatedText in
                        debugPrint("Updated text: \(updatedText)")
    //                    email = updatedText
                    })
                    Spacer().frame(height: 20)
                    Group {
                        SecureTextField(placeHolder: "password".localized, text: $password)
                        Spacer().frame(height: 20)
                        SecureTextField(placeHolder: "enter_confirm_password".localized, text: $confirmPassword)
                    }

                    Spacer().frame(height: 20)
                    RoundedButton(title: "signup".localized, isActionRequired: true) {
                        debugPrint("On Click Button")
//                        if let window = UIApplication.shared.windows.first {
//                            window.rootViewController = UIHostingController(rootView: HomeView())
//                            window.makeKeyAndVisible()
//                        }
                        viewModel.onTapSignUp?()
                    }.frame(height: 50)
                    Spacer()
                }.padding(16)
            }
        }
        .edgesIgnoringSafeArea(.top)
        .navigationBarHidden(true)
    }
}

struct SignUpView_Previews: PreviewProvider {
    static var previews: some View {
        SignUpView(viewModel: SignUpViewModel())
    }
}
