//
//  SignUpScreenViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import UIKit
import SwiftUI

class SignUpScreenViewController: BaseHostingViewController<SignUpView> {

    // MARK: - Properties
    private var viewModel: SignUpViewModel

    // MARK: - initView
    init(viewModel: SignUpViewModel) {
        self.viewModel = viewModel
        super.init(with: SignUpView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.onTapSignUp = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            // Perform your navigation code here
            // For example, pushing a new view controller
            let viewModel = HomeViewModel()
            let vc = HomeScreenViewController(viewModel: viewModel)
            let navigationController = UINavigationController(rootViewController: vc)
            if let window = UIApplication.shared.windows.first {
                window.rootViewController = navigationController
                window.makeKeyAndVisible()
            }
        }

        viewModel.onTapBack = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
    }
}
