//
//  RideCompleteViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 02/09/23.
//

import UIKit

class RideCompleteViewController: BaseHostingViewController<RideCompleteView> {

    // MARK: - Properties
    private var viewModel: RideCompleteViewModel

    // MARK: - initView
    init(viewModel: RideCompleteViewModel) {
        self.viewModel = viewModel
        super.init(with: RideCompleteView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.onTapOk = { [weak self] in
            let viewModel = HomeViewModel()
            let vc = HomeScreenViewController(viewModel: viewModel)
            let navigationController = UINavigationController(rootViewController: vc)
            if let window = UIApplication.shared.windows.first {
                window.rootViewController = navigationController
                window.makeKeyAndVisible()
            }
        }
    }
}
