//
//  RideCompleteView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 02/09/23.
//

import SwiftUI

struct RideCompleteView: View {
    var viewModel: RideCompleteViewModel

    var body: some View {
        VStack {
            Image("ic_done")
                .resizable()
                .aspectRatio(contentMode: .fit)
                .frame(height: 200)
            Spacer().frame(height: 10)
            Text("thankyou_for_choosing_us".localized)
                .modifier(PrimaryLabel(
                    size: .largeFont,
                    color: .primaryBlack,
                    weight: .bold,
                    alignment: .center
                ))
            Spacer().frame(height: 10)
            HStack {
                Text("fare_charge".localized)
                    .modifier(PrimaryLabel(
                        size: .titleFont,
                        color: .grey,
                        weight: .regular,
                        alignment: .center
                    ))

                Text(self.viewModel.amount)
                    .modifier(PrimaryLabel(
                        size: .largeFont,
                        color: .primaryBlack,
                        weight: .bold,
                        alignment: .center
                    ))
            }
            Spacer().frame(height: 10)
            RoundedButton(title: "ok".localized, isActionRequired: true) {
                viewModel.onTapOk?()
            }.frame(height: 50)
        }
        .padding(16)
        .edgesIgnoringSafeArea(.all)
        .navigationBarHidden(true)
    }
}

struct RideCompleteView_Previews: PreviewProvider {
    static var previews: some View {
        RideCompleteView(viewModel: RideCompleteViewModel(amount: "0"))
    }
}
