//
//  LoginView.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct LoginView: View {
    @State private var email = ""
    @State private var password = ""
//    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>
    // MARK: - Variable
    var viewModel: LoginViewModel

    var body: some View {
        VStack {
            HeaderView(title: "login".localized, headerBackgroundColor: Color.clear, titleColor: Color.primaryBlack, onBackTapped: {
                viewModel.onTapBack?()
            })
            VStack {
                SingleLineTextField(placeHolder: "email".localized, text: $email, onChangeText: { updatedText in
                    debugPrint("Updated text: \(updatedText)")

                })
                Spacer().frame(height: 20)
                SecureTextField(placeHolder: "password".localized, text: $password)
                Spacer().frame(height: 20)
                HStack {
                    Spacer()
                    Text("forgot_password".localized)
                        .modifier(PrimaryLabel(
                            size: .subTitleFont,
                            color: .grey,
                            weight: .medium))
                        .onTapGesture {
                            viewModel.onTapForgotPassword?()
                        }.frame(height: 50)
                }
                Spacer().frame(height: 20)
                RoundedButton(title: "login".localized, isActionRequired: true) {
                    debugPrint("On Click Button")
                    viewModel.emailAddress = self.email
                    viewModel.password = self.password
                    viewModel.onTapLogin?()
                }.frame(height: 50)
                Spacer()
            }.padding(16)
        }
        .edgesIgnoringSafeArea(.top)
        .navigationBarHidden(true)
    }
}

struct LoginView_Previews: PreviewProvider {
    static var previews: some View {
        LoginView(viewModel: LoginViewModel())
    }
}
