//
//  LoginScreenViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import UIKit

class LoginScreenViewController: BaseHostingViewController<LoginView> {

    // MARK: - Properties
    private var viewModel: LoginViewModel

    // MARK: - initView
    init(viewModel: LoginViewModel) {
        self.viewModel = viewModel
        super.init(with: LoginView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.onTapLogin = {
            if self.viewModel.emailAddress.isEmpty {
                Helper.showErrorMessage(strMessage: "err_empty_email_address".localized)
                return
            }
            if self.viewModel.password.isEmpty {
                Helper.showErrorMessage(strMessage: "password_min_length_error".localized)
                return
            }

            if self.viewModel.isUserExist(email: self.viewModel.emailAddress.trim()){
                self.viewModel.saveUserLogin(email: self.viewModel.emailAddress.trim())
                let viewModel = HomeViewModel()
                let homeVC = HomeScreenViewController(viewModel: viewModel)
                let navigationController = UINavigationController(rootViewController: homeVC)
                if let window = UIApplication.shared.windows.first {
                    window.rootViewController = navigationController
                    window.makeKeyAndVisible()
                }
            }else{
                Helper.showErrorMessage(strMessage: "err_invalid_username".localized)
            }
        }
        viewModel.onTapForgotPassword = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            guard let self = self else { return }

            // Perform your navigation code here
            // For example, pushing a new view controller
            let viewModel = ForgotPasswordViewModel()
            let forgotPasswordVc = ForgotPasswordViewController(viewModel: viewModel)
            self.navigationController?.pushViewController(forgotPasswordVc, animated: true)
        }

        viewModel.onTapBack = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
    }
}
