//
//  OnBoardView.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct IntroView: View {
    // MARK: - Variable
    var viewModel: IntroViewModel

    var body: some View {
//        NavigationView {
            VStack {
                Spacer()
                Image("bus_home") // Replace with the name of your image asset
                    .resizable()
                    .aspectRatio(contentMode: .fit)
                    .frame(height: 200)
                Spacer()
                Text("travel_by_bus_made_simple".localized)
                    .modifier(PrimaryLabel(
                        size: .largeFont,
                        color: .primaryBlack,
                        weight: .bold,
                        alignment: .center))
                Spacer().frame(height: 15)
                Text("intro_sub_message".localized)
                    .modifier(PrimaryLabel(
                        size: .subTitleFont,
                        color: .primaryBlack,
                        weight: .medium,
                        alignment: .center))
                Spacer()
                HStack {
                    RoundedButton(title: "login".localized, isActionRequired: true) {
                        debugPrint("On Click Button")
                        viewModel.onTapLogin?()
                    }.frame(height: 50)
                    Spacer().frame(width: 20)
                    RoundedButton(title: "signup".localized, isActionRequired: true) {
                        debugPrint("On Click Button")
                        viewModel.onTapSignUp?()
                    }.frame(height: 50)
                }
            }.padding(16)
//        }
    }
}

struct OnBoardView_Previews: PreviewProvider {
    static var previews: some View {
        IntroView(viewModel: IntroViewModel())
    }
}
