//
//  IntroScreenViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import UIKit

class IntroScreenViewController: BaseHostingViewController<IntroView> {

    // MARK: - Properties
    private var viewModel: IntroViewModel

    // MARK: - initView
    init(viewModel: IntroViewModel) {
        self.viewModel = viewModel
        super.init(with: IntroView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.onTapLogin = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            guard let self = self else { return }

            // Perform your navigation code here
            // For example, pushing a new view controller
            let loginViewModel = LoginViewModel()
            let loginVC = LoginScreenViewController(viewModel: loginViewModel)
            self.navigationController?.pushViewController(loginVC, animated: true)
        }

        viewModel.onTapSignUp = { [weak self] in
            // Ensure self is not retained strongly to avoid a retain cycle
            guard let self = self else { return }

            // Perform your navigation code here
            // For example, pushing a new view controller
            let viewModel = SignUpViewModel()
            let vc = SignUpScreenViewController(viewModel: viewModel)
            self.navigationController?.pushViewController(vc, animated: true)
        }

    }
}
