//
//  HomeViewModel.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import Foundation

class HomeViewModel: ObservableObject {

    // MARK: - Variable
    var eventRepository = EventsRepository()
    @Published var nextStop: String = ""
    @Published var currentStop: String = ""
    @Published var busLine: String = ""
    @Published var currentDateTime: String = ""
    @Published var qrImage: String = "bus_home"
    var beOutTime = ""
    var busID: String = ""
    var stopID: String = ""
    var uuid: String = ""
    var price: String = "10"
    var routeId: String = ""
    // MARK: - Initialisation

    func getEvents(completion: @escaping (Result<EventsResponse, BaseError>) -> Void){
        let parameters = [
            "page": "1",
            "size": "10",
            "sort": "id",
            "direction": "DESC",
            "customerEmail": AccountRepository().getEmail(),
            "status": [],
            "dateFrom": "",
            "dateTo": ""
        ] as [String: Any]
        eventRepository.getEvents(request: parameters) { result in
            switch result {
            case .success(let response):
                completion(.success(response))
            case .failure:
                break
            }
        }

    }
    func getEvent(status: String, uuid: String, completion: @escaping (Result<EventResponse, BaseError>) -> Void){
        let parameters = [
            "customerEmail": AccountRepository().getEmail(),
            "routeUuid": self.routeId.trim(),
            "stopUuid": self.stopID.trim(),
            "busUuid": self.busID.trim(),
            "date": self.currentDateTime.trim(),
            "status": status.uppercased(),
            "uuidEvent": uuid,
            "price": self.price
        ] as [String: Any]

        eventRepository.getEvent(request: parameters) { result in
            switch result {
            case .success(let response):
                completion(.success(response))
            case .failure:
                break
            }
        }

    }
    func getRandomNumberString() -> String {
        // Generate a random number between 0 and 999999
        let number = Int(arc4random_uniform(999999))

        // Convert the number to a 6-digit string with leading zeros if necessary
        let formattedNumber = String(format: "%06d", number)

        return formattedNumber
    }
    func getBusRoute(busRoute: String) -> [BusRoute] {
        return DatabaseManager.shared.getBusRoutes(routeValue: busRoute)
    }

    func getBusStops(routeId: String) -> [BusStops] {
        return DatabaseManager.shared.getBusStops(stopRouteCode: routeId)
    }
}
