//
//  HomeView.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct HomeView: View {
    @State var presentSideMenu = false
    @State var selectedSideMenuTab = 0
    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>
    var eWalletAmt = ""
    var dailyCapping = ""
    var moneySpend = ""
    var viewModel: HomeViewModel
    var nextStop: String = ""
    var currentStop: String = ""
    var qrImage: String = "bus_home"
    var busLine: String = ""
    var attributedString: NSAttributedString?
    var spacer20: some View {
        Spacer().frame(height: 20)
    }

    var body: some View {
        ZStack {
            VStack {
                // HeaderView with a custom title and dismiss action
                HeaderView(title: "be_in_be_out".localized, onMenuTapped: {
                    presentSideMenu.toggle()
                })
                ScrollView {
                    VStack {
                        // ZStack containing the gradient background with corner radius
                        spacer20
                        ZStack {
                            LinearGradient(
                                gradient: Gradient(colors: [.colorPrimary, .colorPrimary, .lightBlue900]),
                                startPoint: .top,
                                endPoint: .bottom
                            )
                            .cornerRadius(15)
                            HStack(alignment: .center) {
                                VerticalMoneyInfoView(amount: eWalletAmt, amountText: "e_wallet_money".localized)
                                Spacer()
                                Divider().background(Color.white).frame(width: 4, height: 80)
                                Spacer()
                                VerticalMoneyInfoView(amount: dailyCapping, amountText: "daily_capping".localized)
                                Spacer()
                                Divider().background(Color.white).frame(width: 4, height: 80)
                                Spacer()
                                VerticalMoneyInfoView(amount: moneySpend, amountText: "money_sent_today".localized)
                            }.padding(8)
                        }
                        .frame(height: 80, alignment: .center)

                        spacer20
                        Text(busLine)
                            .modifier(PrimaryLabel(
                                size: .titleFont,
                                color: .primaryBlack,
                                weight: .medium,
                                alignment: .center
                            ))
                        spacer20
                        HStack {
                            currentStopView.frame(width: 140, alignment: .center)
                            Spacer()
                            Image("expand_arrow")
                                .resizable()
                                .aspectRatio(contentMode: .fit)
                                .frame(width: 40)
                            Spacer()
                            nextStopView.frame(width: 140, alignment: .center)
                        }.padding(8)
                        spacer20

                        if attributedString != nil {
                            boardView.multilineTextAlignment(.center)
                        }
                        spacer20
                        Image(qrImage)
                            .resizable()
                            .aspectRatio(contentMode: .fit)
                            .frame(width: 250, height: 250)
                    }
                    .padding(16) // Apply padding to the inner VStack
                }
            }.edgesIgnoringSafeArea(.top)
                .navigationBarHidden(true) // Hide the navigation bar
            SideMenu(isShowing: $presentSideMenu, content: AnyView(SideMenuView(selectedSideMenuTab: $selectedSideMenuTab, presentSideMenu: $presentSideMenu)))
        }
    }

    var currentStopView: some View {
        VStack {
            Text("current_stop".localized)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .primaryBlack,
                    weight: .regular
                ))
            Circle()
                .frame(width: 30, height: 30)
                .foregroundColor(.grey)
            Text(viewModel.currentStop)
                .lineLimit(3)
                .multilineTextAlignment(.center)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .primaryBlack,
                    weight: .regular
                ))
        }
    }

    var nextStopView: some View {
        VStack {
            Text("next_stop".localized)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .primaryBlack,
                    weight: .regular
                ))
            Circle()
                .frame(width: 30, height: 30)
                .foregroundColor(.grey)
            Text(nextStop)
                .lineLimit(3)
                .multilineTextAlignment(.center)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .primaryBlack,
                    weight: .regular
                ))
        }
    }

    var boardView: some View {
        VStack {
            AttributedText(attributedString)
                .modifier(PrimaryLabel(
                    size: .titleFont, color: .primaryBlack, weight: .regular, alignment: .center
                )).padding()
        }
    }
}

struct HomeView_Previews: PreviewProvider {
    static var previews: some View {
        HomeView(viewModel: HomeViewModel())
    }
}
