//
//  ForgotPasswordView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 31/08/23.
//

import SwiftUI

struct ForgotPasswordView: View {
    @State private var email = ""
    var viewModel: ForgotPasswordViewModel

    var body: some View {
        VStack {
            HeaderView(title: "forgot_password_title".localized, headerBackgroundColor: Color.clear, titleColor: Color.primaryBlack, onBackTapped: {
                viewModel.onTapBack?()
            })
            VStack {
                SingleLineTextField(placeHolder: "email".localized, text: $email, onChangeText: { updatedText in
                    debugPrint("Updated text: \(updatedText)")
                    email = updatedText
                })
                Spacer().frame(height: 20)
                RoundedButton(title: "submit".localized, isActionRequired: true) {
                    debugPrint("On Click Button")
                    viewModel.onTapForgotPassword?()
                }.frame(height: 50)
                Spacer()
            }.padding(16)
        }
        .edgesIgnoringSafeArea(.top)
        .navigationBarHidden(true)
    }
}
