//
//  EventsViewModel.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import Foundation
import SwiftUI


class EventsViewModel: ObservableObject {

    // MARK: - Variable

    let dropDownArray: [String] = ["ALL", "PAYMENT", "TRIP"]
    var selectedStartDate = Date()
    var selectedEndDate = Date()
    var selectedDropdown: Int = 0
    var eventRepository = EventsRepository()
    var filterStartDate = ""
    var filterEndDate = ""
    var sizePerPage = 10
    var direction = "DESC"

    @Published var isLoadingPage = false
    private var currentPage = 1
    private var canLoadMorePages = true

    @Published var items = [Events]()

    var onGoTapped: (() -> Void)?
    var onClearTapped: (() -> Void)?

    // MARK: - Initialisation
    func loadMoreContentIfNeeded(currentItem item: Events?) {
        guard let item = item else {
            loadMoreEvents()
            return
        }

        let thresholdIndex = items.index(items.endIndex, offsetBy: -5)
        if items.firstIndex(where: { $0.id == item.id }) == thresholdIndex {
            self.isLoadingPage = false
            self.currentPage += 1
            loadMoreEvents()
        }
    }

    func getEvents(){
        isLoadingPage = false
        currentPage = 1
        canLoadMorePages = true

        var filterValues: [String] = []
        if selectedDropdown == 0 {
            filterValues.removeAll()
        }else if selectedDropdown == 2 {
            filterValues.removeAll()
            filterValues.append("IN")
            filterValues.append("OUT")
        }else if selectedDropdown == 1 {
            filterValues.removeAll()
            filterValues.append("PAYMENT")
        }else{
            filterValues.removeAll()
        }

        let parameters = [
            "page": currentPage,
            "size": sizePerPage,
            "sort": "id",
            "direction": direction,
            "customerEmail": AccountRepository().getEmail(),
            "filterValue": filterValues.isEmpty ? [""] : filterValues,
            "dateFrom": filterStartDate,
            "dateTo": filterEndDate
        ] as [String: Any]
        eventRepository.getEvents(request: parameters) { result in
            switch result {
            case .success(let response):
                self.items.removeAll()
                self.items = response.data.data ?? []
                self.canLoadMorePages = true
            case .failure:
                break
            }
        }
    }

    func loadMoreEvents(){
        guard !isLoadingPage && canLoadMorePages else {
            return
        }

        isLoadingPage = true

        var filterValues: [String] = []
        if selectedDropdown == 0 {
            filterValues.removeAll()
        }else if selectedDropdown == 2 {
            filterValues.removeAll()
            filterValues.append("IN")
            filterValues.append("OUT")
        }else if selectedDropdown == 1 {
            filterValues.removeAll()
            filterValues.append("PAYMENT")
        }else{
            filterValues.removeAll()
        }

        let parameters = [
            "page": currentPage,
            "size": sizePerPage,
            "sort": "id",
            "direction": direction,
            "customerEmail": AccountRepository().getEmail(),
            "filterValue": filterValues.isEmpty ? [""] : filterValues,
            "dateFrom": filterStartDate,
            "dateTo": filterEndDate
        ] as [String: Any]
        eventRepository.getEvents(request: parameters) { result in
            switch result {
            case .success(let response):
                if (response.data.data ?? []).isEmpty {
                    self.canLoadMorePages = false
                }else{
                    self.canLoadMorePages = true
                }
                self.items.append(contentsOf: response.data.data ?? [])


            case .failure:
                break
            }
        }

    }

}
