//
//  EventsView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import SwiftUI

struct EventsView: View {
    @State var presentSideMenu = false
    @State var selectedSideMenuTab = 0
    @State private var isStartDatePickerPresented = false
    @State private var isEndDatePickerPresented = false
    @State private var isDropDownPresented = false
    @State var startDate = ""
    @State var endDate = ""
    @State var selctedDropdonValue = ""
    @State var goBtnAlpha = 0.5
    @State var clearBtnAlpha = 0.5
    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>
    @ObservedObject var viewModel: EventsViewModel
    var items: [Events] = []
    var spacer20: some View {
        Spacer().frame(height: 20)
    }

    var body: some View {
        ZStack {
            VStack {
                HeaderView(title: "menu_events".localized, onMenuTapped: {
                    presentSideMenu.toggle()
                })
                VStack {
                    VStack{
                    HStack {
                        RoundedFilterView(placeHolder: "start_date".localized, text: $startDate, rightImage: Image("calendar")).onTapGesture {
                            self.isStartDatePickerPresented = true
                        }
                        RoundedFilterView(placeHolder: "end_date".localized, text: $endDate, rightImage: Image("calendar")).onTapGesture {
                            self.isEndDatePickerPresented = true
                        }
                    }
                    Spacer().frame(height: 10)
                    HStack {
                        RoundedFilterView(placeHolder: "select".localized, text: $selctedDropdonValue, rightImage: Image("ic_down")).onTapGesture {
                            self.isDropDownPresented = true
                        }
                        HStack {
                            RoundedButton(title: "go".localized, isActionRequired: true,actionCallback: {
                                self.viewModel.onGoTapped?()
                            },color: .blue.opacity(goBtnAlpha))
                            .frame(height: 40)
                            RoundedButton(title: "clear".localized, isActionRequired: true, actionCallback: {
                                self.selctedDropdonValue = ""
                                self.startDate = ""
                                self.endDate = ""
                                self.goBtnAlpha = 0.5
                                self.clearBtnAlpha = 0.5
                                self.viewModel.onClearTapped?()
                            }, color: .blue.opacity(clearBtnAlpha))
                            .frame(height: 40)
                        }
                    }
                }.padding(16)

                    ScrollView {
                        LazyVStack{
                        ForEach(self.viewModel.items, id: \.id) { item in
                            eventCardView(event: item)
                                .onAppear {
                                    self.viewModel.loadMoreContentIfNeeded(currentItem: item)
                                }
                        }
                        if self.viewModel.isLoadingPage {
                            ProgressView()
                        }
                    }
                    }
                    Spacer()
                }

            }.edgesIgnoringSafeArea(.top)
                .navigationBarHidden(true) // Hide the navigation bar

            SideMenu(isShowing: $presentSideMenu, content: AnyView(SideMenuView(selectedSideMenuTab: $selectedSideMenuTab, presentSideMenu: $presentSideMenu)))
        }.fullScreenPresent(isPresented: $isStartDatePickerPresented) {
            DateTimePicker(selectedDate: Binding<Date>(
                get: { return viewModel.selectedStartDate },
                set: { newValue in
                    self.startDate = DateUtilities.formatDateToString(date: newValue, toFormat: "dd/MM/YYYY HH:mm:ss") ?? ""
                    viewModel.selectedStartDate = newValue
                    viewModel.filterStartDate = self.startDate
                    self.goBtnAlpha = viewModel.filterStartDate.isEmpty ? 0.5 : 1.0
                    self.clearBtnAlpha = viewModel.filterStartDate.isEmpty ? 0.5 : 1.0
                }
            ))
        }
        .fullScreenPresent(isPresented: $isEndDatePickerPresented) {
            DateTimePicker(selectedDate: Binding<Date>(
                get: { return viewModel.selectedEndDate },
                set: { newValue in
                    self.endDate = DateUtilities.formatDateToString(date: newValue, toFormat: "dd/MM/YYYY HH:mm:ss") ?? ""
                    viewModel.selectedEndDate = newValue
                    viewModel.filterEndDate = self.endDate
                    self.goBtnAlpha = viewModel.filterEndDate.isEmpty ? 0.5 : 1.0
                    self.clearBtnAlpha = viewModel.filterEndDate.isEmpty ? 0.5 : 1.0
                }
            ))
        }
        .fullScreenPresent(isPresented: $isDropDownPresented) {
            ItemPickerView(selection: Binding<Int>(
                get: { return viewModel.selectedDropdown },
                set: { newValue in
                    self.selctedDropdonValue = viewModel.dropDownArray[newValue].localized
                    viewModel.selectedDropdown = newValue
                    self.goBtnAlpha = viewModel.selectedDropdown == 0 ? 0.5 : 1.0
                    self.clearBtnAlpha = viewModel.selectedDropdown == 0 ? 0.5 : 1.0

                }
            ), items: viewModel.dropDownArray)
        }.background(Color.backGround)
    }

    func eventCardView(event: Events) -> some View {
        ZStack {
            RoundedRectangle(cornerRadius: 8)
                .fill(Color.white)
                .shadow(radius: 5)
            VStack(alignment: .leading, spacing: 10) {
                HStack {
                    Text("date".localized + " " + (event.date ?? ""))
                        .modifier(PrimaryLabel(
                            size: .detailsFont,
                            color: .primaryBlack,
                            weight: .regular))
                         //DateUtilities.formatDateToString(dateString: event.date ?? "", fromFormat: "dd/MM/yyyy hh:mm:ss", toFormat: "dd MMM, yyyy HH:mm a") ?? "")
                    Spacer()
                    Text((event.status ?? ""))
                        .modifier(PrimaryLabel(
                            size: .detailsFont,
                            color: .primary,
                            weight: .medium))
                }
                Divider()
                if event.status != "CHARGE" {
                    Text("axis_name".localized + " " + (event.axisName ?? ""))
                        .modifier(PrimaryLabel(
                            size: .detailsFont,
                            color: .primaryBlack,
                            weight: .regular))
                    Text("stop_name".localized + " " + (event.stopName ?? ""))
                        .modifier(PrimaryLabel(
                            size: .detailsFont,
                            color: .primaryBlack,
                            weight: .regular))
                }
                HStack{
                    if event.status != "CHARGE" {
                        Text("vehicle_no".localized + " " + (event.vehicleIdentifier ?? ""))
                            .modifier(PrimaryLabel(
                                size: .detailsFont,
                                color: .primaryBlack,
                                weight: .regular))
                        Spacer()
                    }
                    Text("price".localized + " " + Helper.getCurrencyFormatWithComma(price: (event.price ?? 0.0)))
                        .modifier(PrimaryLabel(
                            size: .detailsFont,
                            color: .primaryBlack,
                            weight: .regular))
                }
            }.padding(10)
        }.padding(.horizontal, 15)
        .padding(.top, 10)
    }
}

struct EventsView_Previews: PreviewProvider {
    static var previews: some View {
        EventsView(viewModel: EventsViewModel())
    }
}
