//
//  EventScreenViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import UIKit

class EventScreenViewController: BaseHostingViewController<EventsView> {

    // MARK: - Properties
    private var viewModel: EventsViewModel

    // MARK: - initView
    init(viewModel: EventsViewModel) {
        self.viewModel = viewModel
        super.init(with: EventsView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
        self.getAllEvents()
        self.navigationController?.viewControllers = [self]
    }
    func getAllEvents(){
        viewModel.getEvents()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.onClearTapped = {

            if !self.viewModel.filterEndDate.isEmpty || !self.viewModel.filterStartDate.isEmpty || self.viewModel.selectedDropdown != 0 {
                self.viewModel.filterEndDate = ""
                self.viewModel.filterStartDate = ""
                self.viewModel.selectedStartDate = Date()
                self.viewModel.selectedEndDate = Date()
                self.viewModel.selectedDropdown = 0
                self.getAllEvents()

            }else{
                return
            }
        }

        viewModel.onGoTapped = {
            if self.viewModel.filterEndDate.isEmpty && self.viewModel.filterStartDate.isEmpty && self.viewModel.selectedDropdown == 0 {
                return
            }
            self.getAllEvents()
        }
    }
}
