//
//  CustomPopUp.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 04/09/23.
//

import SwiftUI

//TODO:- Usage
//self.viewControllerHolder?.present(style: .overCurrentContext, transitionStyle: .crossDissolve) {
//    CustomPopUp(title: "",
//                message: "You have just left the bus at 18:49, stop XELIDWNH, line 03-PARAT-ALIKHAT",
//                leadingButtontitle: "no".localized,
//                trailingButtontitle: "agree".localized,
//                leadingButtonCallback: {
//        debugPrint("Leading call back")
//    }) {
//        debugPrint("Trailing call back")
//    }
//}

struct CustomPopUp: View {
    // MARK: Public
    let title: String
    let message: String
    let attributedString: NSAttributedString?
    let leadingButtontitle: String
    let trailingButtontitle: String
    var leadingButtonCallback: (() -> Void)?
    var trailingButtonCallback: (() -> Void)?

    // MARK: Variable
    @Environment(\.viewController) private var viewControllerHolder: UIViewController?

    var body: some View {
        VStack(alignment: .center) {
            if title.isNotEmpty {
                Text(title)
                    .modifier(PrimaryLabel(
                        size: .subTitleFont, color: .primaryBlack, weight: .bold
                    )).padding()
            }
            if message.isNotEmpty {
                Text(message)
                    .modifier(PrimaryLabel(
                        size: .titleFont, color: .primaryBlack, weight: .regular, alignment: .center
                    )).padding()
            }else{
                AttributedText(attributedString)
                    .modifier(PrimaryLabel(
                        size: .titleFont, color: .primaryBlack, weight: .regular, alignment: .center
                    )).padding()
            }

            HStack {
                if leadingButtontitle.isNotEmpty {
                    RoundedButton(title: leadingButtontitle, isActionRequired: true) {
                        debugPrint("On Click Button")
                        self.leadingButtonCallback?()
                        self.viewControllerHolder?.dismiss(animated: true, completion: nil)
                    }.frame(height: 50)
                }
                if trailingButtontitle.isNotEmpty && leadingButtontitle.isNotEmpty {
                    Spacer().frame(width: 10)
                }
                if trailingButtontitle.isNotEmpty {
                    RoundedButton(title: trailingButtontitle, isActionRequired: true) {
                        debugPrint("On Click Button")
                        self.trailingButtonCallback?()
                        self.viewControllerHolder?.dismiss(animated: true, completion: nil)
                    }.frame(height: 50)
                }
            }.padding()
        }.background(Color.white).clipShape(RoundedRectangle(cornerRadius: 3.0)).frame(width: UIScreen.main.bounds.size.width - 32)
            .shadow(radius: 3).cornerRadius(15).padding(16)
    }
}
