//
//  ContactUsView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import SwiftUI

struct ContactUsView: View {
    var viewModel: ContactUsViewModel
    // MARK: - Variable
    @State var email = ""
    @State var comment = ""
    @State var presentSideMenu = false
    @State var selectedSideMenuTab = 0
    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>

    var spacer20: some View {
        Spacer().frame(height: 20)
    }

    var body: some View {
        ZStack {
            VStack {
                HeaderView(title: "menu_contact_us".localized, onMenuTapped: {
                    presentSideMenu.toggle()
                })
                ScrollView {
                    VStack(alignment: .leading) {
                        SingleLineTextField(placeHolder: "email".localized, text: $email, onChangeText: { updatedText in
                            debugPrint("Updated text: \(updatedText)")
                            email = updatedText
                        })
                        Spacer().frame(height: 20)
                        HStack {
                            Text("comment".localized)
                                .modifier(PrimaryLabel(
                                    size: .detailsFont,
                                    color: .grey,
                                    weight: .medium,
                                    alignment: .leading
                                ))
                            Spacer()
                        }
                        Spacer().frame(height: 16)
                        TextView(text: $comment, onTextChanged: { newValue in
                            debugPrint("Updated text: \(newValue)")
                        })
                        .frame(minHeight: 80)
                        Spacer().frame(height: 20)
                        RoundedButton(title: "submit".localized, isActionRequired: true) {
                            debugPrint("On Click Button")
                        }.frame(height: 50)
                        Spacer() // Spacer to push content to the bottom
                    }.padding(16)
                }
            }
            SideMenu(isShowing: $presentSideMenu, content: AnyView(SideMenuView(selectedSideMenuTab: $selectedSideMenuTab, presentSideMenu: $presentSideMenu)))
        }.edgesIgnoringSafeArea(.top)
            .navigationBarHidden(true)
    }
}

struct ContactUsView_Previews: PreviewProvider {
    static var previews: some View {
        ContactUsView(viewModel: ContactUsViewModel())
    }
}
