//
//  BaseHostingViewController.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import UIKit
import SwiftUI

class BaseHostingViewController<T: View>: BaseViewController {
    var hostingController: UIHostingController<T>
    var rootView: T

    init(with rootView: T) {
        self.rootView = rootView
        self.hostingController = UIHostingController(rootView: rootView)
        super.init(nibName: nil, bundle: nil)
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    override func loadView() {
        super.loadView()
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        addViews()
        setupViews()
        constrainViews()
    }
    func addViews() {
        addChild(hostingController)
        view.addSubview(hostingController.view)
    }

    func setupViews() {
        hostingController.view.backgroundColor = .white
        hostingController.view.translatesAutoresizingMaskIntoConstraints = false
        hostingController.didMove(toParent: self)
        view.sendSubviewToBack(hostingController.view)
    }

    func constrainViews() {
        hostingController.view.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        hostingController.view.leadingAnchor.constraint(equalTo: view.leadingAnchor).isActive = true
        hostingController.view.trailingAnchor.constraint(equalTo: view.trailingAnchor).isActive = true
        hostingController.view.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
    }

    final func hideBottomView() {

    }
}

extension BaseHostingViewController {
    func goToSIMCard() {

    }

    func showBottomSheet(attributedContent: [NSMutableAttributedString] = [],
                         allowSwipeGestures: Bool = true,
                         defaultHeight: CGFloat =  300,
                         actionButtonText: String = "",
                         backgroundColor: UIColor = .primaryBlack) {

//        let viewModel = BottomSheetViewModel(lineItems: attributedContent,
//                                             actionButtonText: actionButtonText)
//        let bottomSheet = BottomSheetViewController(viewModel: viewModel,
//                                                    allowSwipeGestures: allowSwipeGestures,
//                                                    defaultHeight: defaultHeight,
//                                                    backgroundColor: backgroundColor)
//        bottomSheet.modalPresentationStyle = .overCurrentContext
//        present(bottomSheet, animated: false)
    }
}
