//
//  AddWalletView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import SwiftUI

struct AddWalletView: View {
    // MARK: Public
    @State var value = 0.0
    @Environment(\.viewController) private var viewControllerHolder: UIViewController?
    @State private var addWallet = ""

    var onGoTapped: ((String) -> Void)?

    // MARK: - View
    var body: some View {
        VStack(alignment: .center) {
            Text("add_wallet_amount")
                .modifier(PrimaryLabel(
                    size: .titleFont, color: .primaryBlack
                )).padding()
            SingleLineTextField(placeHolder: "enter_amount".localized, text: $addWallet, keyboardType: .decimalPad, onChangeText: { updatedText in
                addWallet = updatedText
            }).padding()
            HStack {
                RoundedButton(title: "cancel".localized, isActionRequired: true) {
                    debugPrint("On Click Button")
                    self.viewControllerHolder?.dismiss(animated: true, completion: nil)
                }.frame(height: 50)
                Spacer().frame(width: 10)
                RoundedButton(title: "submit".localized, isActionRequired: true) {
                    if addWallet.isEmpty {
                        UIApplication.shared.sendAction(#selector(UIResponder.resignFirstResponder), to: nil, from: nil, for: nil)

                        Helper.showErrorMessage(strMessage: "error_enter_amount".localized)
                    }else{
                        onGoTapped?(addWallet)
                        self.viewControllerHolder?.dismiss(animated: true, completion: nil)
                    }
                }.frame(height: 50)
            }.padding()
        }.background(Color.white).clipShape(RoundedRectangle(cornerRadius: 3.0)).frame(width: UIScreen.main.bounds.size.width - 32)
            .shadow(radius: 3).cornerRadius(15).padding(16)
    }
}
