//
//  AccountViewModel.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import Foundation

class AccountViewModel: ObservableObject {

    // MARK: - Variable
    var addWallet: ((String) -> Void)?
    @Published var walletAmount = AccountRepository().getWallet()
    var eventRepository = EventsRepository()
    // MARK: - Initialisation

    func getEvent(price: String, completion: @escaping (Result<EventResponse, BaseError>) -> Void){
        let currentTime = Date()
        let formatter = DateFormatter()
        formatter.dateFormat = "dd/MM/yyyy HH:mm:ss"
        let dateString = formatter.string(from: currentTime)
        let parameters = [
            "customerEmail": AccountRepository().getEmail(),
            "routeUuid": "",
            "stopUuid": "",
            "busUuid": "",
            "date": dateString,
            "status": "CHARGE",
            "uuidEvent": self.getRandomNumberString(),
            "price": price
        ] as [String: Any]

        eventRepository.getEvent(request: parameters) { result in
            switch result {
            case .success(let response):
                completion(.success(response))
            case .failure:
                break
            }
        }

    }
    func getRandomNumberString() -> String {
        // Generate a random number between 0 and 999999
        let number = Int(arc4random_uniform(999999))

        // Convert the number to a 6-digit string with leading zeros if necessary
        let formattedNumber = String(format: "%06d", number)

        return formattedNumber
    }
}
