//
//  AccountView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import SwiftUI

struct AccountView: View {
    @Environment(\.viewController) private var viewControllerHolder: UIViewController?
    @State var presentSideMenu = false
    @State var selectedSideMenuTab = 0
    @Environment(\.presentationMode) var presentationMode: Binding<PresentationMode>

   @ObservedObject var viewModel: AccountViewModel

    var body: some View {
        ZStack {
            VStack {
                // HeaderView with a custom title and dismiss action
                HeaderView(title: "menu_account".localized, onMenuTapped: {
                    presentSideMenu.toggle()
                }).padding(0)
                ScrollView {
                    VStack {
                        ProfileImageView()
                            .frame(height: 250)
                        Group {
                            Spacer().frame(height: 15)
                            cardView(label: "wallet_amount".localized, leadingTitle: Helper.getCurrencyFormatWithComma(price: viewModel.walletAmount))
                            Spacer().frame(height: 15)
                            cardView(label: "add_wallet_amount".localized, leadingIcon: "wallet").onTapGesture {
                                self.viewControllerHolder?.present(style: .overCurrentContext, transitionStyle: .crossDissolve) {
                                    AddWalletView(onGoTapped: { amount in
                                        viewModel.addWallet?(amount)
                                    })
                                }
                            }
                        }
                        .padding([.leading, .trailing], 16)
                        Spacer()
                    }
                    .padding(0)
                    .padding(.top, -10)
                }
            }.edgesIgnoringSafeArea(.top)
                .navigationBarHidden(true)
            SideMenu(isShowing: $presentSideMenu, content: AnyView(SideMenuView(selectedSideMenuTab: $selectedSideMenuTab, presentSideMenu: $presentSideMenu)))
        }
    }

//    func profileImageView() -> some View {
//        ZStack {
//            LinearGradient(
//                gradient: Gradient(colors: [.colorPrimary, .colorPrimary, .lightBlue900]),
//                startPoint: .top,
//                endPoint: .bottom
//            )
//            VStack(alignment: .center) {
//                HStack {
//                    Spacer()
//                    Image("user_profile")
//                        .resizable()
//                        .aspectRatio(contentMode: .fill)
//                        .frame(width: 100, height: 100)
//                        .cornerRadius(50)
//                    Spacer()
//                }
//                Spacer().frame(height: 15)
//                Text("abc@gmail.com")
//                    .modifier(PrimaryLabel(
//                        size: 18,
//                        color: .white,
//                        weight: .bold))
//            }
//        }
//    }

    func cardView(label: String, leadingTitle: String? = "", leadingIcon: String? = nil) -> some View {
        ZStack {
            RoundedRectangle(cornerRadius: 8)
                .fill(Color.white)
                .shadow(radius: 2)
            HStack {
                Text(label)
                    .modifier(PrimaryLabel(
                        size: .titleFont,
                        color: .primaryBlack,
                        weight: .regular))
                Spacer()
                if let title = leadingTitle {
                    Text(title)
                        .modifier(PrimaryLabel(
                            size: .subTitleFont,
                            color: .primaryBlack,
                            weight: .medium))
                }
                if let image = leadingIcon {
                    Image(image)
                        .resizable()
                        .aspectRatio(contentMode: .fit)
                        .frame(width: 25, height: 25)
                }
            }.padding()
        }
        .frame(height: 70)
    }
}

struct AccountView_Previews: PreviewProvider {
    static var previews: some View {
        AccountView(viewModel: AccountViewModel())
    }
}
