//
//  AccountScreenViewController.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import UIKit

class AccountScreenViewController: BaseHostingViewController<AccountView> {

    // MARK: - Properties
    private var viewModel: AccountViewModel

    // MARK: - initView
    init(viewModel: AccountViewModel) {
        self.viewModel = viewModel
        super.init(with: AccountView(viewModel: viewModel))
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.setNavigationBarHidden(true, animated: false)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        navigationController?.setNavigationBarHidden(false, animated: false)
    }

    // MARK: - Setup Views
    override func setupViews() {
        super.setupViews()
        self.setupActions()
    }

    // MARK: - Actions
    private func setupActions() {
        viewModel.addWallet = { price in
            Helper.showProgressHUD(view: self.view)
            var sendPrice = 0

            if price.contains(".") {
                let calPrice = (Double(price)! * 100)
                sendPrice = Int(calPrice)
            } else {
                sendPrice = Int(price)!
            }

            self.viewModel.getEvent(price: String(sendPrice)){ result in
                Helper.hideProgressHUD(view: self.view)
                switch result {
                case .success(let response):
                    AccountRepository().setWallet(wallet: (response.walletBalance > 0) ? response.walletBalance / 100 : 0)
                    self.viewModel.walletAmount = AccountRepository().getWallet()

                case .failure:
                    break
                }

            }
        }

    }
}
