//
//  Style.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import SwiftUI
import Foundation
import UIKit

struct AppFont {

    enum FontType: String {
        case bold = "Poppins-Bold"
        case light = "Poppins-Light"
        case regular = "Poppins-Regular"
        case medium = "Poppins-Medium"
    }
    enum FontSize: CGFloat {
        case largeFont = 22
        case titleFont = 18
        case subTitleFont = 16
        case detailsFont = 13
        case buttonFont = 15
        case miniFont = 9
    }
    static func font(type: FontType, size: FontSize) -> UIFont {
        return UIFont(name: type.rawValue, size: size.rawValue)!
    }
}

struct PrimaryLabel: ViewModifier {
    var size: AppFont.FontSize = AppFont.FontSize.subTitleFont
    var color: Color = .white
    var weight: AppFont.FontType = AppFont.FontType.light
    var alignment: TextAlignment = .leading
    func body(content: Content) -> some View {
        switch weight {
        case .bold:
            content
                .foregroundColor(color)
                .multilineTextAlignment(alignment)
                .font(.custom(AppFont.FontType.bold.rawValue, size: size.rawValue))
//                .font(.system(size: size, weight: .bold))
        case .regular:
            content
                .foregroundColor(color)
                .multilineTextAlignment(alignment)
                .font(.custom(AppFont.FontType.regular.rawValue, size: size.rawValue))
//                .font(.system(size: size, weight: .regular))
        case .medium:
            content
                .foregroundColor(color)
                .multilineTextAlignment(alignment)
                .font(.custom(AppFont.FontType.medium.rawValue, size: size.rawValue))
//                .font(.system(size: size, weight: .medium))
        default:
            content
                .foregroundColor(color)
                .multilineTextAlignment(alignment)
                .font(.custom(AppFont.FontType.light.rawValue, size: size.rawValue))
//                .font(.system(size: size, weight: .light))
//                .font(.custom(poppinsLight, size: size))
        }
    }
}
