//
//  VerticalMoneyInfoView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 01/09/23.
//

import Foundation
import SwiftUI

struct VerticalMoneyInfoView: View {
    var amount = ""
    var amountText = ""

    var body: some View {
        VStack(alignment: .center) {
            Text(amount)
                .modifier(PrimaryLabel(
                    size: .titleFont,
                    color: .white,
                    weight: .medium,
                    alignment: .center
                ))
            Spacer().frame(height: 5)
            Text(amountText)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .white,
                    weight: .regular,
                    alignment: .center
                ))
        }.frame(minWidth: 0, maxWidth: .infinity)
    }
}
