//
//  TextView.swift
//
//
//
//

import SwiftUI

struct TextView: UIViewRepresentable {
    @Binding var text: String
    var onTextChanged: (String) -> Void

    func makeUIView(context: Context) -> UITextView {
        let textView = UITextView()
        textView.delegate = context.coordinator
        textView.isScrollEnabled = true
        textView.isEditable = true
        textView.isUserInteractionEnabled = true
        textView.font = UIFont.preferredFont(forTextStyle: .body)
        textView.text = text
        textView.layer.cornerRadius = 15 // Adjust the value as needed
        textView.clipsToBounds = true
        textView.layer.borderWidth = 1.0 // Adjust the width as needed
        textView.layer.borderColor = UIColor.gray.cgColor
        return textView
    }

    func updateUIView(_ uiView: UITextView, context: Context) {
        if uiView.text != text {
            uiView.text = text
        }
    }

    func makeCoordinator() -> Coordinator {
        Coordinator(self)
    }

    final class Coordinator: NSObject, UITextViewDelegate {
        var parent: TextView

        init(_ parent: TextView) {
            self.parent = parent
        }

        func textViewDidChange(_ textView: UITextView) {
            parent.text = textView.text
            parent.onTextChanged(textView.text)
        }
    }
}
