//
//  SingleLineTextField.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct SingleLineTextField: View {
    var placeHolder = ""
    @Binding var text: String
    var leadingPadding: CGFloat
    var keyboardType: UIKeyboardType = .default
    var onChangeText: (String) -> Void

    init(placeHolder: String, text: Binding<String>, leadingPadding: CGFloat = 0, keyboardType: UIKeyboardType = .default, onChangeText: @escaping (String) -> Void) {
        self.placeHolder = placeHolder
        self._text = text
        self.leadingPadding = leadingPadding
        self.onChangeText = onChangeText
        self.keyboardType = keyboardType
    }

    var body: some View {
        VStack(alignment: .leading) {
            Text(placeHolder)

                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .grey,
                    weight: .medium))

            ZStack(alignment: .leading) {
                Rectangle()
                    .foregroundColor(.clear)
                    .cornerRadius(15)
                    .overlay(
                        RoundedRectangle(cornerRadius: 15)
                            .inset(by: 2)
                            .stroke(Color.grey, lineWidth: 2)
                    )
                TextField(placeHolder, text: $text, onEditingChanged: { _ in
                    onChangeText(text)
                }) .keyboardType(keyboardType)
                .padding(.all, 16)
                    .padding(.leading, CGFloat(leadingPadding))
            }.frame(height: 50)
        }

    }
}
