//
//  SideMenuView.swift
//
//
//  
//

import SwiftUI

enum SideMenuRowType: Int, CaseIterable{
    case home = 0
    case events
    case account
    case contactus
    case logout

    var title: String{
        switch self {
        case .home:
            return "menu_home".localized
        case .events:
            return "menu_events".localized
        case .account:
            return "menu_account".localized
        case .contactus:
            return "menu_contact_us".localized
        case .logout:
            return "menu_logout".localized
        }
    }

//    var iconName: String{
//        switch self {
//        case .home:
//            return "home"
//        case .favorite:
//            return "favorite"
//        case .chat:
//            return "chat"
//        case .profile:
//            return "profile"
//        }
//    }
}

struct SideMenuView: View {

    @Binding var selectedSideMenuTab: Int
    @Binding var presentSideMenu: Bool

    var body: some View {
        HStack {
            ZStack{
                Rectangle()
                    .fill(.white)
                    .frame(width: 270)
                VStack(alignment: .leading, spacing: 0) {
                    ProfileImageView()
                        .frame(height: 250)
                        .padding(.bottom, 30)
                    ForEach(SideMenuRowType.allCases, id: \.self){ row in
                        rowView(isSelected: selectedSideMenuTab == row.rawValue, imageName: nil, title: row.title) {
                            selectedSideMenuTab = row.rawValue
                            presentSideMenu.toggle()
                            switch row {
                            case .home:
                                let viewModel = HomeViewModel()
                                let vc = HomeScreenViewController(viewModel: viewModel)
                                let navigationController = UINavigationController(rootViewController: vc)
                                if let window = UIApplication.shared.windows.first {
                                    window.rootViewController = navigationController
                                    window.makeKeyAndVisible()
                                }
                            case .events:
                                let viewModel = EventsViewModel()
                                let vc = EventScreenViewController(viewModel: viewModel)
                                let navigationController = UINavigationController(rootViewController: vc)
                                if let window = UIApplication.shared.windows.first {
                                    window.rootViewController = navigationController
                                    window.makeKeyAndVisible()
                                }
                            case .account:
                                let viewModel = AccountViewModel()
                                let vc = AccountScreenViewController(viewModel: viewModel)
                                let navigationController = UINavigationController(rootViewController: vc)
                                if let window = UIApplication.shared.windows.first {
                                    window.rootViewController = navigationController
                                    window.makeKeyAndVisible()
                                }
                            case .contactus:
                                let viewModel = ContactUsViewModel()
                                let vc = ContactUsScreenViewController(viewModel: viewModel)
                                let navigationController = UINavigationController(rootViewController: vc)
                                if let window = UIApplication.shared.windows.first {
                                    window.rootViewController = navigationController
                                    window.makeKeyAndVisible()
                                }
                            case .logout:
                                let viewModel = LoginViewModel()
                                let vc = LoginScreenViewController(viewModel: viewModel)
                                let navigationController = UINavigationController(rootViewController: vc)
                                if let window = UIApplication.shared.windows.first {
                                    window.rootViewController = navigationController
                                    window.makeKeyAndVisible()
                                }
                                break
                            }
                        }
                    }
                    Spacer()
                }
//                .padding(.top, UIDevice.current.hasNotch ? UIDevice.current.notchHeight : 0)
                .frame(width: 270)
                .background(
                    Color.white
                )
            }
            Spacer()
        }
//        .background(.clear)
    }

    func rowView(isSelected: Bool, imageName: String?, title: String, hideDivider: Bool = false, action: @escaping (() -> ())) -> some View {
        Button{
            action()
        } label: {
            VStack(alignment: .leading){
                HStack(spacing: 20){
//                    Rectangle()
//                        .fill(isSelected ? .purple : .white)
//                        .frame(width: 5)
                    if let image = imageName {
                        ZStack{
                            Image(image)
                                .resizable()
                                .renderingMode(.template)
                                .foregroundColor(isSelected ? .primaryBlack : .gray)
                                .frame(width: 26, height: 26)
                        }
                        .frame(width: 30, height: 30)
                    }
//                    Text(title)
//                        .font(.system(size: 14, weight: .regular))
//                        .foregroundColor(isSelected ? .primaryBlack : .gray)
                    Text(title)
                        .font(.system(size: 14, weight: .regular))
                        .foregroundColor(.primaryBlack)
                    Spacer()
                }
            }.padding(16)
        }
        .frame(height: 50)
//        .background(
//            LinearGradient(colors: [isSelected ? .purple.opacity(0.5) : .white, .white], startPoint: .leading, endPoint: .trailing)
//        )
    }
}
