//
//  SecureTextField.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct SecureTextField: View {
    var placeHolder = ""
    @Binding var text: String
    var leadingPadding: CGFloat
    @State private var isSecure = true

    init(placeHolder: String, text: Binding<String>, leadingPadding: CGFloat = 0) {
        self.placeHolder = placeHolder
        self._text = text
        self.leadingPadding = leadingPadding
    }

    var body: some View {
        VStack(alignment: .leading) {
            Text(placeHolder)
                .modifier(PrimaryLabel(
                    size: .subTitleFont,
                    color: .grey,
                    weight: .medium))


            ZStack(alignment: .leading) {
                Rectangle()
                    .foregroundColor(.clear)
                    .cornerRadius(15)
                    .overlay(
                        RoundedRectangle(cornerRadius: 15)
                            .inset(by: 2)
                            .stroke(Color.grey, lineWidth: 2)
                    )
                //                SecureField("", text: $text)
                //                    .padding(.all, 16)
                //                    .padding(.leading, CGFloat(leadingPadding))
                if isSecure {
                    HStack {
                        SecureField("", text: $text)
                            .padding(.all, 16)
                            .padding(.leading, CGFloat(leadingPadding))
                        Image(systemName: isSecure ? "eye.slash" : "eye")
                            .foregroundColor(.gray).onTapGesture {
                                isSecure.toggle()
                            }
                        .padding(.trailing, 8)
                    }
                }
                else {
                    HStack {
                        TextField("", text: $text)
                            .padding(.all, 16)
                            .padding(.leading, CGFloat(leadingPadding))
                        Image(systemName: isSecure ? "eye.slash" : "eye")
                            .foregroundColor(.gray).onTapGesture {
                                isSecure.toggle()
                            }
                        .padding(.trailing, 8)
                    }
                }

            }.frame(height: 50)
        }
    }
}
