//
//  RoundedFilterView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 02/09/23.
//

import Foundation
import SwiftUI

struct RoundedFilterView: View {
    var placeHolder = ""
    @Binding var text: String
    var leadingPadding: CGFloat = 15
    var rightImage: Image

    init(placeHolder: String, text: Binding<String>, leadingPadding: CGFloat = 0, rightImage: Image) {
        self.placeHolder = placeHolder
        self._text = text
        self.leadingPadding = leadingPadding
        self.rightImage = rightImage
    }

    var body: some View {
        ZStack(alignment: .leading) {
            Rectangle()
                .foregroundColor(.white)
                .cornerRadius(12)
                .overlay(
                    RoundedRectangle(cornerRadius: 12)
                        .inset(by: 1)
                        .stroke(Color.primaryBlack, lineWidth: 1)
                )
                .background(Color.clear)
            HStack {
                Text(text.isEmpty ? placeHolder : text)
                    .modifier(PrimaryLabel(
                        size: .detailsFont,
                        color: text.isEmpty ? .grey : .primaryBlack,
                        weight: .medium
                    ))
                    .padding(.all, 10)
                    .padding(.leading, CGFloat(leadingPadding))
                Spacer()
                rightImage
                    .resizable()
                    .frame(width: 15, height: 15).padding(.trailing, 15)
            }
        }.frame(height: 35)
    }
}
