//
//  RoundedButton.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI
import Foundation

struct RoundedButton: View {
    var title: String = ""
    var isActionRequired: Bool = false
    var isShowIcon: Bool = false
    var actionCallback: () -> Void
    var color: Color = .blue

    var body: some View {
        ZStack {
            Rectangle()
                .foregroundColor(.clear)
                .background(color)
                .cornerRadius(15)
                .shadow(color: .primaryBlack.opacity(0.1), radius: 4, x: 0, y: 4)

            HStack {
                if isActionRequired {
                    Text(title)
                        .modifier(PrimaryLabel(
                            size: .buttonFont,
                            color: .white,
                            weight: .bold))
                        .onTapGesture {
                            actionCallback()
                        }
                }
                else {
                    Text(title)
                        .modifier(PrimaryLabel(
                            size: .buttonFont,
                            color: .white,
                            weight: .bold))
                }

                if isShowIcon {
                    Image(systemName: "chevron.right")
                        .foregroundColor(.white)
                }
            }
        }
    }
}
