//
//  ProfileImageView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 04/09/23.
//

import SwiftUI

struct ProfileImageView: View {
    var body: some View {
        ZStack {
            LinearGradient(
                gradient: Gradient(colors: [.colorPrimary, .colorPrimary, .lightBlue900]),
                startPoint: .top,
                endPoint: .bottom
            )
            VStack(alignment: .center) {
                HStack {
                    Spacer()
                    Image("user_profile")
                        .resizable()
                        .aspectRatio(contentMode: .fill)
                        .frame(width: 100, height: 100)
                        .cornerRadius(50)
                    Spacer()
                }
                Spacer().frame(height: 15)
                Text(AccountRepository().getEmail())
                    .modifier(PrimaryLabel(
                        size: .titleFont,
                        color: .white,
                        weight: .bold))
                    .accentColor(.white)
            }
        }
    }
}

struct ProfileImageView_Previews: PreviewProvider {
    static var previews: some View {
        ProfileImageView()
    }
}
