//
//  ItemPickerView.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 02/09/23.
//

import SwiftUI

struct ItemPickerView: View {
    @Environment(\.presentationMode) var presentationMode

    @Binding var selection: Int
    var items = [String]()

    var body: some View {
        VStack {
            Spacer()
            VStack {
                HStack {
                    Spacer()
                    Text("done".localized)
                        .modifier(PrimaryLabel(
                            size: .buttonFont,
                            color: .primaryBlack,
                            weight: .bold))
                        .onTapGesture {
//                            onChangeText(selection)
                            presentationMode.wrappedValue.dismiss()
                        }
                    Spacer().frame(width: 16)
                }.frame(height: 50)
                Picker(selection: $selection, label:
                        Text("Select")) {
                    ForEach(0 ..< items.count) { index in
                        Text(self.items[index].localized).tag(index)
                    }
                }.pickerStyle(WheelPickerStyle())
            }.background(Color.white).edgesIgnoringSafeArea(.bottom)
        }
        .background(BackgroundCleanerView()).edgesIgnoringSafeArea(.all)
    }
}
