//
//  HeaderView.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-01 on 29/08/23.
//

import SwiftUI

struct HeaderView: View {
    var title: String
    var headerBackgroundColor: Color = .blue
    var titleColor: Color = Color.white
    var onBackTapped: (() -> Void)?
    var onMenuTapped: (() -> Void)?

    var body: some View {
        //        HStack {
        //            Spacer().frame(height: UIDevice.current.hasNotch ? 52 : 0)
        HStack {
            Group {
                if let onBackTapped = onBackTapped {
                    Image(systemName: "chevron.backward")
                        .resizable()
                        .aspectRatio(contentMode: .fit)
                        .frame(width: 30, height: 30)
                        .onTapGesture {
                            onBackTapped()
                        }
                }
                if let onMenuTapped = onMenuTapped {
                    Image("ic_menu")
                        .resizable()
                        .aspectRatio(contentMode: .fit)
                        .frame(width: 30, height: 30)
                        .onTapGesture {
                            onMenuTapped()
                        }
                }
                Spacer().frame(width: 15)
                Text(title)
                    .modifier(PrimaryLabel(
                        size: .largeFont,
                        color: titleColor,
                        weight: .medium))
                Spacer()
            }.padding(.top, UIDevice.current.hasNotch ? UIDevice.current.notchHeight : 0)
        }.padding()
            .frame(height: UIDevice.current.hasNotch ? UIDevice.current.notchHeight == 20 ? 92 : 112 : 70).background(headerBackgroundColor).edgesIgnoringSafeArea(.top).padding(.bottom, -8)
    }
}
