//
//  File.swift
//  BeInBeOutAMCO
//
//  Created by Mac-01 on 02/09/23.
//

import Foundation
import SwiftUI

struct DateTimePicker: View {
    @Environment(\.presentationMode) var presentationMode
    @Binding var selectedDate: Date

    var body: some View {
        VStack {
            Spacer()
            VStack(alignment: .leading) {
                HStack {
                    Spacer()
                    Text("done".localized)
                        .modifier(PrimaryLabel(
                            size: .titleFont,
                            color: .black,
                            weight: .bold))
                        .onTapGesture {
                            presentationMode.wrappedValue.dismiss()
                        }
                    Spacer().frame(width: 16)
                }.frame(height: 35)
                DatePicker("", selection: $selectedDate ,in: ...Date(), displayedComponents: [.date, .hourAndMinute])
                    .datePickerStyle(WheelDatePickerStyle())
                    .fixedSize().frame(maxWidth: .infinity, alignment: .center)
            }.background(Color.white)
        }
        .background(BackgroundCleanerView()).edgesIgnoringSafeArea(.all)
    }
}
