//
//  AttributedString.swift
//
//

import Foundation
import UIKit

class AttributedString {
    var attributeType: NSAttributedString.Key!
    var subString: String = ""
    var subStringFont: UIFont = .systemFont(ofSize: 14)
    var subStringColor: UIColor = .red
    var isUnderlined: Bool = false
    var isStrikeThrough: Bool = false
    var underlineStyle: Int = NSUnderlineStyle.single.rawValue
    var underlineColor: UIColor = .white
    var backgroundColor: UIColor = .clear

    init() {}

    init(subString: String, isUnderline: Bool, underlineColor: UIColor = .white) {
        self.subString = subString
        isUnderlined = isUnderline
        self.underlineColor = underlineColor
    }

    init(subString: String, isUnderline: Bool, subStringColor: UIColor, subStringFont: UIFont, backgroundColor: UIColor = .clear, underlineColor: UIColor = .white) {
        self.subString = subString
        isUnderlined = isUnderline
        self.subStringColor = subStringColor
        self.subStringFont = subStringFont
        self.backgroundColor = backgroundColor
        self.underlineColor = underlineColor
    }

    init(subString: String, isUnderline: Bool, subStringColor: UIColor, underlineColor: UIColor) {
        self.subString = subString
        isUnderlined = isUnderline
        self.underlineColor = underlineColor
        self.subStringColor = subStringColor
    }

    init(subString: String, isUnderline: Bool, subStringColor: UIColor, underlineColor: UIColor, subStringFont: UIFont) {
        self.subString = subString
        isUnderlined = isUnderline
        self.underlineColor = underlineColor
        self.subStringColor = subStringColor
        self.subStringFont = subStringFont
    }

    init(subString: String, subStringFont: UIFont, subStringColor: UIColor, isStrikeThrough: Bool = false) {
        self.subString = subString
        self.subStringFont = subStringFont
        self.subStringColor = subStringColor
        self.isStrikeThrough = isStrikeThrough
    }

    init(subString: String, subStringFont: UIFont, subStringColor: UIColor, isUnderlined: Bool, underlineStyle: Int, underlineColor: UIColor) {
        self.subString = subString
        self.subStringFont = subStringFont
        self.subStringColor = subStringColor
        self.isUnderlined = isUnderlined
        self.underlineStyle = underlineStyle
        self.underlineColor = underlineColor
    }

    init(attributeType: NSAttributedString.Key, subString: String, subStringFont: UIFont, subStringColor: UIColor, isStrikeThrough: Bool = false) {
        self.attributeType = attributeType
        self.subString = subString
        self.subStringFont = subStringFont
        self.subStringColor = subStringColor
        self.isStrikeThrough = isStrikeThrough
    }
}
