//
//  EventsRepository.swift
//  BeInBeOutAMCO
//
//  Created by My on 05/09/23.
//

import Foundation
import Alamofire
import Foundation

class EventsRepository {

    // Event API
    func getEvent(request: Parameters, completion: @escaping (Result<EventResponse, BaseError>) -> Void) {
        APIManager.callWebService(apiUrl: AppURL.API.event, params: request, encodableParams: EmptyStruct(), resultType: EventResponse.self, customHeader: nil, httpMethod: .post) { result in

            switch result {
            case let .success(response):
                completion(.success(response))
            case let .failure(error):
                completion(.failure(error))
            }
        }
    }

    // Events API
        func getEvents(request: Parameters, completion: @escaping (Result<EventsResponse, BaseError>) -> Void) {

            APIManager.callWebService(apiUrl: AppURL.API.events, params: request, encodableParams: EmptyStruct(), resultType: EventsResponse.self, customHeader: nil, httpMethod: .post)
            { result in

                switch result {
                case let .success(response):
                    completion(.success(response))

                case let .failure(error):
                    completion(.failure(error))

                }
            }
        }

//    func getEvents(request: Parameters, completion: @escaping (Result<EventsResponse, BaseError>) -> Void) {
//        let reParam = request
//        let apiUrl = String(format: AppURL.API.events)
//        guard let serviceUrl = URL(string: apiUrl) else { return }
//        let parameterDictionary = reParam
//        var request = URLRequest(url: serviceUrl)
//        request.httpMethod = "POST"
//        request.setValue("Application/json", forHTTPHeaderField: "Content-Type")
//        guard let httpBody = try? JSONSerialization.data(withJSONObject: parameterDictionary, options: []) else {
//            return
//        }
//        request.httpBody = httpBody
//
//        let session = URLSession.shared
//        session.dataTask(with: request) { (data, response, error) in
//            if let response = response {
//                debugPrint(response)
//            }
//            if let data = data {
//                let feedback = NSString(data: data, encoding: NSUTF8StringEncoding)
//                debugPrint(feedback)
//                
//            }
//        }.resume()
//    }

    //    func getEvents(request: Parameters, completion: @escaping (Result<EventsResponse, BaseError>) -> Void) {
    //
    //        APIManager.sendDataToServerWithHeaders(apiUrl: AppURL.API.events, params: request, encodableParams: EmptyStruct(), resultType: EventsResponse.self, customHeader: nil, httpMethod: .post)
    //        {  (result, msg, isSuccess) in
    //            if isSuccess {
    //                //completion(.success(EventsResponse.self))
    //            }else{
    //                //completion(.failure(BaseError.self))
    //            }
    //        }
    //    }
}
