//
//  AccountRepository.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-07 on 22/06/23.
//

import Alamofire
import Foundation

class AccountRepository {

    // SignIn API
    func signIn(request: Parameters, completion: @escaping (Result<SignInResponse, BaseError>) -> Void) {
        APIManager.callWebService(apiUrl: AppURL.API.login, params: request, encodableParams: EmptyStruct(), resultType: SignInResponse.self, customHeader: nil, httpMethod: .post) { result in

            switch result {
            case let .success(response):
                PreferenceManager.shared.accessToken = response.content.token ?? ""
                self.saveUserInfo(info: response)
            case .failure:
                break
            }

            completion(result)
        }
    }
    func customerSignIn(request: Parameters, completion: @escaping (Result<CustomerLoginResponse, BaseError>) -> Void) {
        APIManager.callWebService(apiUrl: AppURL.API.loginCustomer, params: request, encodableParams: EmptyStruct(), resultType: CustomerLoginResponse.self, customHeader: nil, httpMethod: .post) { result in

            switch result {
            case let .success(response):
                PreferenceManager.shared.userToken = response.content.customerToken ?? ""

            case .failure:
                break
            }

            completion(result)
        }
    }

}

// MARK: FUNCTIONS TO INTERECT WITH PREFERNCE MANAGER

extension AccountRepository {
    static var isUserLoggedIn: Bool {
        return !AccountRepository.getAccessToken().isEmpty
    }

    private func saveUserInfo(info: SignInResponse) {
        PreferenceManager.shared.userId = info.content.userId ?? 0
        PreferenceManager.shared.email = info.content.username ?? ""
        PreferenceManager.shared.firstName = info.content.userFirstName ?? ""
        PreferenceManager.shared.lastName = info.content.userLastName ?? ""
    }

    static func setAccessToken(_ accessToken: String) {
        PreferenceManager.shared.accessToken = accessToken
    }

    static func getAccessToken() -> String {
        return PreferenceManager.shared.accessToken
    }

    func getUserId() -> Int {
        PreferenceManager.shared.userId
    }
    func setEmail(email: String) {
        PreferenceManager.shared.email = email
    }
    func getEmail() -> String {
        PreferenceManager.shared.email
    }

    func setWallet(wallet: Double) {
        PreferenceManager.shared.eWallet = wallet
    }
    func getWallet() -> Double {
        PreferenceManager.shared.eWallet
    }

    func getFirstName() -> String {
        PreferenceManager.shared.firstName
    }

    func getLastName() -> String {
        PreferenceManager.shared.lastName
    }

    func setUUID(uuiD:String) {
        PreferenceManager.shared.uuID = uuiD
    }
    func getUUID() -> String {
      return PreferenceManager.shared.uuID
    }

    static func clearPreferenceData() {
        PreferenceManager.shared.clearPreferenceData()
    }
}

struct EmptyStruct: Encodable {}
