//
//  PreferenceManager.swift
//
//

import CryptoSwift
import Foundation
import UIKit

class PreferenceManager {
    static let shared = PreferenceManager()
    private enum Key {
        static let accessToken = "accessToken"
        static let userToken = "userToken"
        static let userId = "userId"
        static let email = "email"
        static let firstName = "firstName"
        static let lastName = "lastName"
        static let eWallet = "eWallet"
        static let uuID = "uuID"
    }

    var accessToken: String {
        get {
            return UserDefaults.standard.string(forKey: Key.accessToken) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.accessToken)
            UserDefaults.standard.synchronize()
        }
    }
    var uuID: String {
        get {
            return UserDefaults.standard.string(forKey: Key.uuID) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.uuID)
            UserDefaults.standard.synchronize()
        }
    }
    var userToken: String {
        get {
            return UserDefaults.standard.string(forKey: Key.userToken) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.userToken)
            UserDefaults.standard.synchronize()
        }
    }

    var eWallet: Double {
        get {
            return UserDefaults.standard.double(forKey: Key.eWallet)
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.eWallet)
            UserDefaults.standard.synchronize()
        }
    }

    var userId: Int {
        get {
            return UserDefaults.standard.integer(forKey: Key.userId)
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.userId)
            UserDefaults.standard.synchronize()
        }
    }

    var email: String {
        get {
            return UserDefaults.standard.string(forKey: Key.email) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.email)
            UserDefaults.standard.synchronize()
        }
    }

    var firstName: String {
        get {
            return UserDefaults.standard.string(forKey: Key.firstName) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.firstName)
            UserDefaults.standard.synchronize()
        }
    }

    var lastName: String {
        get {
            return UserDefaults.standard.string(forKey: Key.lastName) ?? ""
        }
        set {
            UserDefaults.standard.set(newValue, forKey: Key.lastName)
            UserDefaults.standard.synchronize()
        }
    }


    // MARK: - App launch count

    func clearPreferenceData() {
        for key in UserDefaults.standard.dictionaryRepresentation().keys where key != Key.accessToken {
            UserDefaults.standard.removeObject(forKey: key.description)
        }
       
        UserDefaults.standard.synchronize()
    }
}
