//
//  DatabaseManager.swift
//  BeInBeOutAMCO
//
//  Created by My on 02/09/23.
//

import FMDB
import Darwin

class DatabaseManager {
    var dbQueue: FMDatabaseQueue!
    var database: FMDatabase!
    static let shared = DatabaseManager()
    private let dbName = "beinbeout.db"
    struct Table {
        static let busStopTable = "BusStopTable"
        static let customersTable = "CustomersTable"
        static let inOutTable = "InOutTable"
        static let routesTable = "RoutesTable"

    }
    struct BusStopTable {
        static let stopId = "stop_id"
        static let stopCode = "stop_code"
        static let stopValue = "stop_value"
        static let stopRouteCode = "stop_route_code"
    }
    struct CustomersTable {
        static let customerId = "customer_id"
        static let email = "email"
        static let customerDateTime = "customer_date_time"
    }
    struct InOutTable {
        static let eventUuid = "event_uuid"
        static let inStationCode = "in_station_code"
        static let inStation = "in_station"
        static let inTime = "in_time"
        static let outTime = "out_time"
        static let outStation = "out_station"
        static let outStationCode = "out_station_code"
    }
    struct RoutesTable {
        static let routeID = "route_id"
        static let routeCode = "route_code"
        static let routeValue = "route_value"
    }


    func setupDatabase() {
        let url = copyDatabaseIfNeeded().path
        database = FMDatabase(path: url)
        database.close()
        dbQueue = FMDatabaseQueue.init(path: url)
        debugPrint("Database Path: \(url)")
        if database.open() {
            debugPrint("Database opened")
        } else {
            debugPrint("Unable to open database")
        }
    }
    // MARK: - Other
    func copyDatabaseIfNeeded() -> URL {
        // Move database file from bundle to documents folder
        let fileManager = FileManager.default
        let documentsUrl = fileManager.urls(for: .documentDirectory, in: .userDomainMask)
        let finalDatabaseURL = documentsUrl.first!.appendingPathComponent(String(format: "%@-ios-v%@-%@.db", dbName, Helper.getVersion(), Helper.getBuildVersion()))
        if !((try? finalDatabaseURL.checkResourceIsReachable()) ?? false) {
            debugPrint("DB does not exist in documents folder")
            let documentsURL = Bundle.main.resourceURL?.appendingPathComponent(dbName)
            do {
                try fileManager.copyItem(atPath: (documentsURL?.path)!, toPath: finalDatabaseURL.path)
            } catch let error as NSError {
                debugPrint("Couldn't copy file to final location! Error:\(error.description)")
            }
        } else {
            debugPrint("Database file found at path: \(finalDatabaseURL.path)")
        }
        return finalDatabaseURL
    }
}

extension DatabaseManager {
    // MARK: - Bus Route

    func insertBusRouteItem(item: BusRoute) {
        self.dbQueue.inDatabase { (database) in
            let columns: String = "\(RoutesTable.routeID),\(RoutesTable.routeCode),\(RoutesTable.routeValue)"
            let routeValue = item.routeValue
            let routeCode = item.routeCode
            let routeID = item.routeId
            let query = """
                INSERT INTO \(Table.routesTable) (\(columns)) VALUES ('\(routeID)','\(routeCode)','\(routeValue)')
                """
            if !database.executeStatements(query) {
                debugPrint("Bus Route Query \(query)")
                debugPrint("Failed to insert data: \(Table.busStopTable): \(database.lastErrorMessage())")
            } else {
                debugPrint("Successfully inserted into Service Policy with Query \(query)")
            }
        }
    }

    func getBusRoutes(routeValue: String = "") -> [BusRoute] {
        var busRoutes: [BusRoute] = []
        self.dbQueue.inDatabase { (database) in
            var query: String = ""

                query = "SELECT * FROM \(Table.routesTable) WHERE \(RoutesTable.routeCode) = '\(routeValue)'"
                debugPrint(query)
            if let resultSet = database.executeQuery(query, withArgumentsIn: []) {
                while resultSet.next() {
                    let routeID = Int(resultSet.int(forColumn: RoutesTable.routeID))
                    let routeCode = resultSet.string(forColumn: RoutesTable.routeCode) ?? ""
                    let routeValue = resultSet.string(forColumn: RoutesTable.routeValue) ?? ""

                    busRoutes.append(BusRoute.init(routeId: routeID, routeCode: routeCode, routeValue: routeValue))
                }
                resultSet.close()
            }
        }
        return busRoutes
    }

    // MARK: - Bus Stops
    func insertBusStopItem(item: BusStops) {
        self.dbQueue.inDatabase { (database) in
            let columns: String = "\(BusStopTable.stopId),\(BusStopTable.stopCode),\(BusStopTable.stopValue),\(BusStopTable.stopRouteCode)"
            let stopId = item.stopId
            let stopCode = item.stopCode
            let stopValue = item.stopValue
            let stopRouteCode = item.stopRouteCode
            let query = """
                INSERT INTO \(Table.busStopTable) (\(columns)) VALUES ('\(stopId)','\(stopCode)','\(stopValue)','\(stopRouteCode)')
                """
            if !database.executeStatements(query) {
                debugPrint("Bus Route Query \(query)")
                debugPrint("Failed to insert data: \(Table.busStopTable): \(database.lastErrorMessage())")
            } else {
                debugPrint("Successfully inserted into Service Policy with Query \(query)")
            }
        }
    }
        func getBusStops(stopRouteCode: String = "") -> [BusStops] {
            var busStops: [BusStops] = []
            self.dbQueue.inDatabase { (database) in
                var query: String = ""

                query = "SELECT * FROM \(Table.busStopTable) WHERE \(BusStopTable.stopRouteCode) = '\(stopRouteCode)'"
                debugPrint(query)
                if let resultSet = database.executeQuery(query, withArgumentsIn: []) {
                    while resultSet.next() {
                        let stopId = Int(resultSet.int(forColumn: BusStopTable.stopId))
                        let stopCode = resultSet.string(forColumn: BusStopTable.stopCode) ?? ""
                        let stopValue = resultSet.string(forColumn: BusStopTable.stopValue) ?? ""
                        let stopRouteCode = resultSet.string(forColumn: BusStopTable.stopRouteCode) ?? ""

                        busStops.append(BusStops.init(stopId: stopId, stopCode: stopCode, stopValue: stopValue, stopRouteCode: stopRouteCode))
                    }
                    resultSet.close()
                }
            }
            return busStops
        }


    // MARK: - Customer Table
    func insertCustomerItem(item: Customer) {
        self.dbQueue.inDatabase { (database) in
            let columns: String = "\(CustomersTable.customerId),\(CustomersTable.email),\(CustomersTable.customerDateTime)"
            let customerID = item.id
            let email = item.email
            let dateTime = item.datetime
            let query = """
                INSERT INTO \(Table.customersTable) (\(columns)) VALUES ('\(customerID)','\(email)','\(dateTime)')
                """
            if !database.executeStatements(query) {
                debugPrint("Bus Route Query \(query)")
                debugPrint("Failed to insert data: \(Table.customersTable): \(database.lastErrorMessage())")
            } else {
                debugPrint("Successfully inserted into Service Policy with Query \(query)")
            }
        }
    }

    func isUserExist(emailAddress: String) -> Bool {
        var isExist = false
        self.dbQueue.inDatabase { (database) in
            let query = "SELECT * FROM \(Table.customersTable) WHERE \(CustomersTable.email) LIKE ?"

               // Execute the query with a wildcard '%' to match substrings
               let resultSet = database.executeQuery(query, withArgumentsIn: ["%\(emailAddress)%"])

               // Check if there are any matching rows
               if resultSet != nil && resultSet!.next() {
                   isExist = true
               } else {
                   isExist = false
               }
        }
        return isExist
    }

    func getCustomers() -> [Customer] {
        var customerList: [Customer] = []
        self.dbQueue.inDatabase { (database) in
            let    query = "SELECT * FROM \(Table.customersTable)"
            if let resultSet = database.executeQuery(query, withArgumentsIn: []) {
                while resultSet.next() {
                    let id = Int(resultSet.int(forColumn: CustomersTable.customerId))
                    let email = resultSet.string(forColumn: CustomersTable.email) ?? ""
                    let customerDateTime = resultSet.string(forColumn: CustomersTable.customerDateTime) ?? ""

                    customerList.append(Customer.init(id: id, email: email, datetime: customerDateTime))
                }
                resultSet.close()
            }
        }
        return customerList
    }

    //MARK: - In-Out Table
    func insertInOutItem(item: InOutData) {
        self.dbQueue.inDatabase { (database) in

            let columns: String = "\(InOutTable.eventUuid),\(InOutTable.inStationCode),\(InOutTable.inStation),\(InOutTable.inTime)"
//,\(InOutTable.outTime),\(InOutTable.outStation),\(InOutTable.outStationCode)
            let eventUuid = item.eventUuid
            let inStation = item.inStation
            let inStationCode = item.inStationCode
            let inTime = item.inTime

//            let outTime = item.outTime
//            let outStation = item.outStation
//            let outStationCode = item.outStationCode
            let query = """
                INSERT INTO \(Table.inOutTable) (\(columns)) VALUES ('\(eventUuid)','\(inStation)','\(inStationCode)','\(inTime)')
                """
            if !database.executeStatements(query) {
                debugPrint("Bus Route Query \(query)")
                debugPrint("Failed to insert data: \(Table.inOutTable): \(database.lastErrorMessage())")
            } else {
                debugPrint("Successfully inserted into Service Policy with Query \(query)")
            }
        }
    }

}
