//
//  BaseError.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-07 on 27/06/23.
//

import Foundation

enum BaseError: Error {
    case inputValidationError(statusCode: Int, message: String, validationError: [ValidationError] = [])
    case parsingError(statusCode: Int, message: String)
    case unauthorized(statusCode: Int, message: String)
    case forcefullyLogout(statusCode: Int, message: String)
    case resourceNotFound(statusCode: Int, message: String)
    case internalServerError(statusCode: Int, message: String)
    case badGateway(statusCode: Int, message: String)
    case serviceUnavailable(statusCode: Int, message: String)
    case authenticationFailed(statusCode: Int, message: String)
    case noInternetConnection
    case unknown

    var statusCode: Int {
        switch self {
        case let .inputValidationError(statusCode, _, _),
             let .parsingError(statusCode, _),
             let .unauthorized(statusCode, _),
             let .forcefullyLogout(statusCode, _),
             let .resourceNotFound(statusCode, _),
             let .internalServerError(statusCode, _),
             let .badGateway(statusCode, _),
             let .serviceUnavailable(statusCode, _),
             let .authenticationFailed(statusCode, _):
            return statusCode
        case .unknown, .noInternetConnection:
            return 0
        }
    }

    var message: String {
        switch self {
        case let .inputValidationError(_, message, _),
             let .parsingError(_, message),
             let .unauthorized(_, message),
             let .forcefullyLogout(_, message),
             let .resourceNotFound(_, message),
             let .internalServerError(_, message),
             let .badGateway(_, message),
             let .serviceUnavailable(_, message),
             let .authenticationFailed(_, message):
            return message
        case .unknown:
            return "something_went_wrong".localized
        case .noInternetConnection:
            return "no_connection_message".localized
        }
    }

    var validationError: [ValidationError] {
        switch self {
        case let .inputValidationError(_, _, validationError):
            return validationError
        default:
            return []
        }
    }
}

enum ValidationErrorFiled: String {
    case email
    case password
}
