//
//  EventsResponse.swift
//  BeInBeOutAMCO
//
//  Created by My on 05/09/23.
//

import Foundation

class EventsResponse: Codable {
    let response: String
    let data: EventsContent

    enum CodingKeys: String, CodingKey {
        case response
        case data
    }
    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.response = try container.decode(String.self, forKey: .response)
        self.data = try container.decode(EventsContent.self, forKey: .data)
    }
}

class EventsContent: Codable {
    var total: Int = 0
    var totalAmount: Double = 0
    var dailyUntilNow: Double = 0
    var walletBalance: Double = 0
    var dailyFairCapping: Double = 0
    var data: [Events]?

    enum CodingKeys: String, CodingKey {
        case total
        case totalAmount
        case dailyUntilNow
        case walletBalance
        case dailyFairCapping
        case data
    }
    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.total = try container.decode(Int.self, forKey: .total)
        if let dailyUntilNowValue = try? container.decode(Double.self, forKey: .dailyUntilNow) {
            // Successfully decoded as an Int
            self.dailyUntilNow = dailyUntilNowValue
        } else {
            let dailyUntil = try container.decode(Int.self, forKey: .dailyUntilNow)
            self.dailyUntilNow = Double(dailyUntil)
        }

        if let totalAmountValue = try? container.decode(Double.self, forKey: .totalAmount) {
            // Successfully decoded as an Int
            self.totalAmount = totalAmountValue
        } else {
            let amount = try container.decode(Int.self, forKey: .totalAmount)
            self.totalAmount = Double(amount)
        }

        if let walletBalanceValue = try? container.decode(Double.self, forKey: .walletBalance) {
            // Successfully decoded as an Int
            self.walletBalance = walletBalanceValue
        } else {
            let wallet = try container.decode(Int.self, forKey: .walletBalance)
            self.walletBalance = Double(wallet)
        }

        if let dailyFairValue = try? container.decode(Double.self, forKey: .dailyFairCapping) {
            // Successfully decoded as an Int
            self.dailyFairCapping = dailyFairValue
        } else {
            let dailyFair = try container.decode(Int.self, forKey: .dailyFairCapping)
            self.dailyFairCapping = Double(dailyFair)
        }

        self.data = try container.decodeIfPresent([Events].self, forKey: .data)
    }
}
class Events: Codable {
    var id: Int = 0
    var customerId: Int = 0
    var wallet: Double?
    var status: String?
    var axisId: Int?
    var stopId: Int?
    var vehicleId: Int?
    var stopName: String?
    var vehicleIdentifier: String?
    var date: String?
    var logDate: String?
    var uuidEvent: String?
    var price: Double?
    var axisName: String?

    enum CodingKeys: String, CodingKey {
        case id
        case customerId
        case wallet
        case status
        case axisId
        case stopId
        case vehicleId
        case stopName
        case vehicleIdentifier
        case date
        case logDate
        case uuidEvent
        case price
        case axisName
    }
    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.id = try container.decode(Int.self, forKey: .id)
        self.customerId = try container.decode(Int.self, forKey: .customerId)
        self.status = try container.decodeIfPresent(String.self, forKey: .status)
        self.axisId = try container.decodeIfPresent(Int.self, forKey: .axisId)
        self.stopId = try container.decodeIfPresent(Int.self, forKey: .stopId)
        self.vehicleId = try container.decodeIfPresent(Int.self, forKey: .vehicleId)
        self.stopName = try container.decodeIfPresent(String.self, forKey: .stopName)
        self.vehicleIdentifier = try container.decodeIfPresent(String.self, forKey: .vehicleIdentifier)
        self.date = try container.decodeIfPresent(String.self, forKey: .date)
        self.logDate = try container.decodeIfPresent(String.self, forKey: .logDate)
        self.uuidEvent = try container.decodeIfPresent(String.self, forKey: .uuidEvent)

        self.axisName = try container.decodeIfPresent(String.self, forKey: .axisName)

        if let priceValue = try? container.decode(Double.self, forKey: .price) {
            // Successfully decoded as an Int
            self.price = priceValue
        } else {
            let priceInt = try container.decode(Int.self, forKey: .price)
            self.price = Double(priceInt)
        }

        if let walletValue = try? container.decode(Double.self, forKey: .wallet) {
            // Successfully decoded as an Int
            self.wallet = walletValue
        } else {
            let walletInt = try container.decode(Int.self, forKey: .wallet)
            self.wallet = Double(walletInt)
        }

    }
}
